/*
 * Decompiled with CFR 0.152.
 */
package com.github.tehras.loadingskeleton;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.github.tehras.loadingskeleton.helpers.LoadingSkeletonViewConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u001a\u0010\u0017\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\u0013J\u0006\u0010\u0019\u001a\u00020\u0013R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/github/tehras/loadingskeleton/LoadingSkeleton;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "(Landroid/content/Context;)V", "defStyleAttrs", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "containerViewId", "skeletonViewConverter", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "getSkeletonViewConverter", "()Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "setSkeletonViewConverter", "(Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;)V", "populateView", "", "v", "Landroid/view/ViewGroup;", "viewConverter", "revertView", "start", "stop", "loading-skeleton_release"})
public final class LoadingSkeleton
extends FrameLayout {
    private final int containerViewId = 10001;
    @NotNull
    private LoadingSkeletonViewConverter skeletonViewConverter;

    @NotNull
    public final LoadingSkeletonViewConverter getSkeletonViewConverter() {
        return this.skeletonViewConverter;
    }

    public final void setSkeletonViewConverter(@NotNull LoadingSkeletonViewConverter loadingSkeletonViewConverter) {
        Intrinsics.checkParameterIsNotNull((Object)loadingSkeletonViewConverter, (String)"<set-?>");
        this.skeletonViewConverter = loadingSkeletonViewConverter;
    }

    @NotNull
    public final LoadingSkeleton skeletonViewConverter(@NotNull LoadingSkeletonViewConverter skeletonViewConverter) {
        Intrinsics.checkParameterIsNotNull((Object)skeletonViewConverter, (String)"skeletonViewConverter");
        this.skeletonViewConverter = skeletonViewConverter;
        return this;
    }

    public final void stop() {
        if (this.getChildCount() != 1) {
            throw (Throwable)new RuntimeException("View must have 1 child");
        }
        View view = this.getChildAt(0);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup container = (ViewGroup)view;
        if (container.getId() != this.containerViewId) {
            return;
        }
        View child = container.getChildAt(0);
        if (!(container instanceof ViewGroup)) {
            throw (Throwable)new Exception("Layout must be a ViewGroup");
        }
        this.revertView(container, this.skeletonViewConverter);
        container.removeView(child);
        this.removeView((View)container);
        this.addView(child);
    }

    public final void start() {
        if (this.getChildCount() != 1) {
            throw (Throwable)new RuntimeException("View must have 1 child");
        }
        View layout = this.getChildAt(0);
        if (layout.getId() == this.containerViewId) {
            return;
        }
        this.removeView(layout);
        if (!(layout instanceof ViewGroup)) {
            throw (Throwable)new Exception("Layout must be a ViewGroup");
        }
        this.populateView((ViewGroup)layout, this.skeletonViewConverter);
        ViewGroup container = this.skeletonViewConverter.shimmerEnabled() ? (ViewGroup)new ShimmerFrameLayout(this.getContext()) : (ViewGroup)new FrameLayout(this.getContext());
        container.setId(this.containerViewId);
        container.addView(layout);
        if (container instanceof ShimmerFrameLayout) {
            ((ShimmerFrameLayout)container).startShimmerAnimation();
        }
        this.addView((View)container);
    }

    /*
     * WARNING - void declaration
     */
    private final void populateView(ViewGroup v, LoadingSkeletonViewConverter viewConverter) {
        block3: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ViewGroup viewGroup;
            ViewGroup viewGroup2 = v;
            if (viewGroup2 == null) break block3;
            ViewGroup it = viewGroup = viewGroup2;
            Iterable iterable = (Iterable)new IntRange(0, v.getChildCount());
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                View view = v.getChildAt((int)it2);
                collection.add(view);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                View it3 = (View)element$iv;
                if (it3 instanceof ViewGroup) {
                    this.populateView((ViewGroup)it3, viewConverter);
                    continue;
                }
                if (!(it3 instanceof View)) continue;
                viewConverter.convertView(it3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void revertView(ViewGroup v, LoadingSkeletonViewConverter viewConverter) {
        block3: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ViewGroup viewGroup;
            ViewGroup viewGroup2 = v;
            if (viewGroup2 == null) break block3;
            ViewGroup it = viewGroup = viewGroup2;
            Iterable iterable = (Iterable)new IntRange(0, v.getChildCount());
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                View view = v.getChildAt((int)it2);
                collection.add(view);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                View it3 = (View)element$iv;
                if (it3 instanceof ViewGroup) {
                    this.revertView((ViewGroup)it3, viewConverter);
                    continue;
                }
                if (!(it3 instanceof View)) continue;
                viewConverter.revertView(it3);
            }
        }
    }

    public LoadingSkeleton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttrs);
        this.containerViewId = 10001;
        this.skeletonViewConverter = new LoadingSkeletonViewConverter.Builder().build();
    }

    public LoadingSkeleton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public LoadingSkeleton(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }
}

