/*
 * Decompiled with CFR 0.152.
 */
package com.github.tehras.loadingskeleton.view_streamers;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.github.tehras.loadingskeleton.helpers.LoadingSkeletonViewStreamer;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/tehras/loadingskeleton/view_streamers/DefaultImageViewStreamer;", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewStreamer;", "Landroid/widget/ImageView;", "()V", "drawables", "Ljava/util/ArrayList;", "Landroid/graphics/drawable/Drawable;", "Lkotlin/collections/ArrayList;", "index", "", "convert", "", "c", "Landroid/content/Context;", "v", "color", "revert", "start", "stop", "loading-skeleton_release"})
public final class DefaultImageViewStreamer
extends LoadingSkeletonViewStreamer<ImageView> {
    private ArrayList<Drawable> drawables = new ArrayList();
    private int index;

    @Override
    public void start() {
        super.start();
        this.drawables = new ArrayList();
    }

    @Override
    public void stop() {
        super.stop();
        this.index = 0;
    }

    @Override
    public void revert(@NotNull Context c, @NotNull ImageView v) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        if (v.getDrawable() != null) {
            v.getDrawable().clearColorFilter();
        }
        v.setImageDrawable(this.drawables.get(this.index));
        int n = this.index;
        this.index = n + 1;
    }

    @Override
    public void convert(@NotNull Context c, @NotNull ImageView v, int color2) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        this.drawables.add(v.getDrawable());
        v.setImageDrawable(null);
        v.setImageDrawable(c.getResources().getDrawable(color2));
        v.getDrawable().setColorFilter(color2, PorterDuff.Mode.DST_OVER);
        v.getDrawable().setColorFilter(color2, PorterDuff.Mode.DST_ATOP);
    }

    public DefaultImageViewStreamer() {
        super(ImageView.class);
    }
}

