/*
 * Decompiled with CFR 0.152.
 */
package com.plattysoft.leonids;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.plattysoft.leonids.AnimatedParticle;
import com.plattysoft.leonids.Particle;
import com.plattysoft.leonids.ParticleField;
import com.plattysoft.leonids.initializers.AccelerationInitializer;
import com.plattysoft.leonids.initializers.ParticleInitializer;
import com.plattysoft.leonids.initializers.RotationInitiazer;
import com.plattysoft.leonids.initializers.RotationSpeedInitializer;
import com.plattysoft.leonids.initializers.ScaleInitializer;
import com.plattysoft.leonids.initializers.SpeeddByComponentsInitializer;
import com.plattysoft.leonids.initializers.SpeeddModuleAndRangeInitializer;
import com.plattysoft.leonids.modifiers.AlphaModifier;
import com.plattysoft.leonids.modifiers.ParticleModifier;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class ParticleSystem {
    private static final long DEFAULT_UPDATE_INTERVAL = 50L;
    private long mUpdateInterval;
    private ViewGroup mParentView;
    private int mMaxParticles;
    private Random mRandom;
    private ParticleField mDrawingView;
    private ArrayList<Particle> mParticles;
    private final List<Particle> mActiveParticles;
    private long mTimeToLive;
    private long mCurrentTime;
    private float mParticlesPerMillisecond;
    private int mActivatedParticles;
    private long mEmittingTime;
    private List<ParticleModifier> mModifiers;
    private List<ParticleInitializer> mInitializers;
    private ValueAnimator mAnimator;
    private Timer mTimer;
    private final ParticleTimerTask mTimerTask;
    private float mDpToPxScale;
    private int[] mParentLocation;
    private int mEmitterXMin;
    private int mEmitterXMax;
    private int mEmitterYMin;
    private int mEmitterYMax;

    private ParticleSystem(Context context, int maxParticles, long timeToLive, ViewGroup parentViewGroup) {
        this.mUpdateInterval = 50L;
        this.mActiveParticles = new ArrayList<Particle>();
        this.mCurrentTime = 0L;
        this.mTimerTask = new ParticleTimerTask(this);
        this.mRandom = new Random();
        this.mParentLocation = new int[2];
        this.mParentView = parentViewGroup;
        this.setParentViewGroup(this.mParentView);
        this.mModifiers = new ArrayList<ParticleModifier>();
        this.mInitializers = new ArrayList<ParticleInitializer>();
        this.mMaxParticles = maxParticles;
        this.mParticles = new ArrayList();
        this.mTimeToLive = timeToLive;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDpToPxScale = displayMetrics.xdpi / 160.0f;
    }

    public ParticleSystem(Activity a, int maxParticles, int drawableRedId, long timeToLive) {
        this(a, maxParticles, a.getResources().getDrawable(drawableRedId), timeToLive, 0x1020002);
    }

    public ParticleSystem(Activity a, int maxParticles, int drawableRedId, long timeToLive, int parentViewId) {
        this(a, maxParticles, a.getResources().getDrawable(drawableRedId), timeToLive, parentViewId);
    }

    public ParticleSystem(Activity a, int maxParticles, Drawable drawable, long timeToLive) {
        this(a, maxParticles, drawable, timeToLive, 0x1020002);
    }

    public ParticleSystem(Activity a, int maxParticles, Drawable drawable, long timeToLive, int parentViewId) {
        this((Context)a, maxParticles, drawable, timeToLive, (ViewGroup)a.findViewById(parentViewId));
    }

    public ParticleSystem(Context context, int maxParticles, Drawable drawable, long timeToLive, ViewGroup parentView) {
        block3: {
            block2: {
                this(context, maxParticles, timeToLive, parentView);
                if (!(drawable instanceof BitmapDrawable)) break block2;
                Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
                for (int i = 0; i < this.mMaxParticles; ++i) {
                    this.mParticles.add(new Particle(bitmap));
                }
                break block3;
            }
            if (!(drawable instanceof AnimationDrawable)) break block3;
            AnimationDrawable animation = (AnimationDrawable)drawable;
            for (int i = 0; i < this.mMaxParticles; ++i) {
                this.mParticles.add(new AnimatedParticle(animation));
            }
        }
    }

    private float dpToPx(float dp) {
        return dp * this.mDpToPxScale;
    }

    public ParticleSystem(Activity a, int maxParticles, Bitmap bitmap, long timeToLive) {
        this(a, maxParticles, bitmap, timeToLive, 0x1020002);
    }

    public ParticleSystem(Activity a, int maxParticles, Bitmap bitmap, long timeToLive, int parentViewId) {
        this((Context)a, maxParticles, bitmap, timeToLive, (ViewGroup)a.findViewById(parentViewId));
    }

    public ParticleSystem(Context context, int maxParticles, Bitmap bitmap, long timeToLive, ViewGroup parentView) {
        this(context, maxParticles, timeToLive, parentView);
        for (int i = 0; i < this.mMaxParticles; ++i) {
            this.mParticles.add(new Particle(bitmap));
        }
    }

    public ParticleSystem(Activity a, int maxParticles, AnimationDrawable animation, long timeToLive) {
        this(a, maxParticles, animation, timeToLive, 0x1020002);
    }

    public ParticleSystem(Activity a, int maxParticles, AnimationDrawable animation, long timeToLive, int parentViewId) {
        this(a, maxParticles, animation, timeToLive, (ViewGroup)a.findViewById(parentViewId));
    }

    public ParticleSystem(Activity a, int maxParticles, AnimationDrawable animation, long timeToLive, ViewGroup parentView) {
        this((Context)a, maxParticles, timeToLive, parentView);
        for (int i = 0; i < this.mMaxParticles; ++i) {
            this.mParticles.add(new AnimatedParticle(animation));
        }
    }

    public ParticleSystem addModifier(ParticleModifier modifier) {
        this.mModifiers.add(modifier);
        return this;
    }

    public ParticleSystem setUpdateInterval(long interval) {
        this.mUpdateInterval = interval;
        return this;
    }

    public ParticleSystem setSpeedRange(float speedMin, float speedMax) {
        this.mInitializers.add(new SpeeddModuleAndRangeInitializer(this.dpToPx(speedMin), this.dpToPx(speedMax), 0, 360));
        return this;
    }

    public ParticleSystem setSpeedModuleAndAngleRange(float speedMin, float speedMax, int minAngle, int maxAngle) {
        while (maxAngle < minAngle) {
            maxAngle += 360;
        }
        this.mInitializers.add(new SpeeddModuleAndRangeInitializer(this.dpToPx(speedMin), this.dpToPx(speedMax), minAngle, maxAngle));
        return this;
    }

    public ParticleSystem setSpeedByComponentsRange(float speedMinX, float speedMaxX, float speedMinY, float speedMaxY) {
        this.mInitializers.add(new SpeeddByComponentsInitializer(this.dpToPx(speedMinX), this.dpToPx(speedMaxX), this.dpToPx(speedMinY), this.dpToPx(speedMaxY)));
        return this;
    }

    public ParticleSystem setInitialRotationRange(int minAngle, int maxAngle) {
        this.mInitializers.add(new RotationInitiazer(minAngle, maxAngle));
        return this;
    }

    public ParticleSystem setScaleRange(float minScale, float maxScale) {
        this.mInitializers.add(new ScaleInitializer(minScale, maxScale));
        return this;
    }

    public ParticleSystem setRotationSpeed(float rotationSpeed) {
        this.mInitializers.add(new RotationSpeedInitializer(rotationSpeed, rotationSpeed));
        return this;
    }

    public ParticleSystem setRotationSpeedRange(float minRotationSpeed, float maxRotationSpeed) {
        this.mInitializers.add(new RotationSpeedInitializer(minRotationSpeed, maxRotationSpeed));
        return this;
    }

    public ParticleSystem setAccelerationModuleAndAndAngleRange(float minAcceleration, float maxAcceleration, int minAngle, int maxAngle) {
        this.mInitializers.add(new AccelerationInitializer(this.dpToPx(minAcceleration), this.dpToPx(maxAcceleration), minAngle, maxAngle));
        return this;
    }

    public ParticleSystem setAcceleration(float acceleration, int angle) {
        this.mInitializers.add(new AccelerationInitializer(acceleration, acceleration, angle, angle));
        return this;
    }

    public ParticleSystem setParentViewGroup(ViewGroup viewGroup) {
        this.mParentView = viewGroup;
        if (this.mParentView != null) {
            this.mParentView.getLocationInWindow(this.mParentLocation);
        }
        return this;
    }

    public ParticleSystem setStartTime(int time) {
        this.mCurrentTime = time;
        return this;
    }

    public ParticleSystem setFadeOut(long millisecondsBeforeEnd, Interpolator interpolator) {
        this.mModifiers.add(new AlphaModifier(255, 0, this.mTimeToLive - millisecondsBeforeEnd, this.mTimeToLive, interpolator));
        return this;
    }

    public ParticleSystem setFadeOut(long duration) {
        return this.setFadeOut(duration, (Interpolator)new LinearInterpolator());
    }

    public void emitWithGravity(View emitter, int gravity, int particlesPerSecond, int emittingTime) {
        this.configureEmitter(emitter, gravity);
        this.startEmitting(particlesPerSecond, emittingTime);
    }

    public void emit(View emitter, int particlesPerSecond, int emittingTime) {
        this.emitWithGravity(emitter, 17, particlesPerSecond, emittingTime);
    }

    public void emit(View emitter, int particlesPerSecond) {
        this.emitWithGravity(emitter, 17, particlesPerSecond);
    }

    public void emitWithGravity(View emitter, int gravity, int particlesPerSecond) {
        this.configureEmitter(emitter, gravity);
        this.startEmitting(particlesPerSecond);
    }

    private void startEmitting(int particlesPerSecond) {
        this.mActivatedParticles = 0;
        this.mParticlesPerMillisecond = (float)particlesPerSecond / 1000.0f;
        this.mDrawingView = new ParticleField(this.mParentView.getContext());
        this.mParentView.addView((View)this.mDrawingView);
        this.mEmittingTime = -1L;
        this.mDrawingView.setParticles(this.mActiveParticles);
        this.updateParticlesBeforeStartTime(particlesPerSecond);
        this.mTimer = new Timer();
        this.mTimer.schedule((TimerTask)this.mTimerTask, 0L, this.mUpdateInterval);
    }

    public void emit(int emitterX, int emitterY, int particlesPerSecond, int emittingTime) {
        this.configureEmitter(emitterX, emitterY);
        this.startEmitting(particlesPerSecond, emittingTime);
    }

    private void configureEmitter(int emitterX, int emitterY) {
        this.mEmitterXMax = this.mEmitterXMin = emitterX - this.mParentLocation[0];
        this.mEmitterYMax = this.mEmitterYMin = emitterY - this.mParentLocation[1];
    }

    private void startEmitting(int particlesPerSecond, int emittingTime) {
        this.mActivatedParticles = 0;
        this.mParticlesPerMillisecond = (float)particlesPerSecond / 1000.0f;
        this.mDrawingView = new ParticleField(this.mParentView.getContext());
        this.mParentView.addView((View)this.mDrawingView);
        this.mDrawingView.setParticles(this.mActiveParticles);
        this.updateParticlesBeforeStartTime(particlesPerSecond);
        this.mEmittingTime = emittingTime;
        this.startAnimator((Interpolator)new LinearInterpolator(), (long)emittingTime + this.mTimeToLive);
    }

    public void emit(int emitterX, int emitterY, int particlesPerSecond) {
        this.configureEmitter(emitterX, emitterY);
        this.startEmitting(particlesPerSecond);
    }

    public void updateEmitPoint(int emitterX, int emitterY) {
        this.configureEmitter(emitterX, emitterY);
    }

    public void oneShot(View emitter, int numParticles) {
        this.oneShot(emitter, numParticles, (Interpolator)new LinearInterpolator());
    }

    public void oneShot(View emitter, int numParticles, Interpolator interpolator) {
        this.configureEmitter(emitter, 17);
        this.mActivatedParticles = 0;
        this.mEmittingTime = this.mTimeToLive;
        for (int i = 0; i < numParticles && i < this.mMaxParticles; ++i) {
            this.activateParticle(0L);
        }
        this.mDrawingView = new ParticleField(this.mParentView.getContext());
        this.mParentView.addView((View)this.mDrawingView);
        this.mDrawingView.setParticles(this.mActiveParticles);
        this.startAnimator(interpolator, this.mTimeToLive);
    }

    private void startAnimator(Interpolator interpolator, long animationTime) {
        this.mAnimator = ValueAnimator.ofInt((int[])new int[]{0, (int)animationTime});
        this.mAnimator.setDuration(animationTime);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int milliseconds = (Integer)animation.getAnimatedValue();
                ParticleSystem.this.onUpdate(milliseconds);
            }
        });
        this.mAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                ParticleSystem.this.cleanupAnimation();
            }

            public void onAnimationCancel(Animator animation) {
                ParticleSystem.this.cleanupAnimation();
            }
        });
        this.mAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mAnimator.start();
    }

    private void configureEmitter(View emitter, int gravity) {
        int[] location = new int[2];
        emitter.getLocationInWindow(location);
        if (this.hasGravity(gravity, 0x800003)) {
            this.mEmitterXMax = this.mEmitterXMin = location[0] - this.mParentLocation[0];
        } else if (this.hasGravity(gravity, 0x800005)) {
            this.mEmitterXMax = this.mEmitterXMin = location[0] + emitter.getWidth() - this.mParentLocation[0];
        } else if (this.hasGravity(gravity, 1)) {
            this.mEmitterXMax = this.mEmitterXMin = location[0] + emitter.getWidth() / 2 - this.mParentLocation[0];
        } else {
            this.mEmitterXMin = location[0] - this.mParentLocation[0];
            this.mEmitterXMax = location[0] + emitter.getWidth() - this.mParentLocation[0];
        }
        if (this.hasGravity(gravity, 48)) {
            this.mEmitterYMax = this.mEmitterYMin = location[1] - this.mParentLocation[1];
        } else if (this.hasGravity(gravity, 80)) {
            this.mEmitterYMax = this.mEmitterYMin = location[1] + emitter.getHeight() - this.mParentLocation[1];
        } else if (this.hasGravity(gravity, 16)) {
            this.mEmitterYMax = this.mEmitterYMin = location[1] + emitter.getHeight() / 2 - this.mParentLocation[1];
        } else {
            this.mEmitterYMin = location[1] - this.mParentLocation[1];
            this.mEmitterYMax = location[1] + emitter.getHeight() - this.mParentLocation[1];
        }
    }

    private boolean hasGravity(int gravity, int gravityToCheck) {
        return (gravity & gravityToCheck) == gravityToCheck;
    }

    private void activateParticle(long delay) {
        Particle p = this.mParticles.remove(0);
        p.init();
        for (int i = 0; i < this.mInitializers.size(); ++i) {
            this.mInitializers.get(i).initParticle(p, this.mRandom);
        }
        int particleX = this.getFromRange(this.mEmitterXMin, this.mEmitterXMax);
        int particleY = this.getFromRange(this.mEmitterYMin, this.mEmitterYMax);
        p.configure(this.mTimeToLive, particleX, particleY);
        p.activate(delay, this.mModifiers);
        this.mActiveParticles.add(p);
        ++this.mActivatedParticles;
    }

    private int getFromRange(int minValue, int maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        return this.mRandom.nextInt(maxValue - minValue) + minValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdate(long milliseconds) {
        while ((this.mEmittingTime > 0L && milliseconds < this.mEmittingTime || this.mEmittingTime == -1L) && !this.mParticles.isEmpty() && (float)this.mActivatedParticles < this.mParticlesPerMillisecond * (float)milliseconds) {
            this.activateParticle(milliseconds);
        }
        List<Particle> list = this.mActiveParticles;
        synchronized (list) {
            for (int i = 0; i < this.mActiveParticles.size(); ++i) {
                boolean active = this.mActiveParticles.get(i).update(milliseconds);
                if (active) continue;
                Particle p = this.mActiveParticles.remove(i);
                --i;
                this.mParticles.add(p);
            }
        }
        if (this.mDrawingView != null) {
            this.mDrawingView.setParticles(this.mActiveParticles);
            this.mDrawingView.postInvalidate();
        }
    }

    private void cleanupAnimation() {
        this.mParentView.removeView((View)this.mDrawingView);
        this.mDrawingView = null;
        this.mParentView.postInvalidate();
        this.mParticles.addAll(this.mActiveParticles);
    }

    public void stopEmitting() {
        this.mEmittingTime = this.mCurrentTime;
    }

    public void cancel() {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.cancel();
        }
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer.purge();
            this.cleanupAnimation();
        }
    }

    private void updateParticlesBeforeStartTime(int particlesPerSecond) {
        if (particlesPerSecond == 0) {
            return;
        }
        long currentTimeInMs = this.mCurrentTime / 1000L;
        long framesCount = currentTimeInMs / (long)particlesPerSecond;
        if (framesCount == 0L) {
            return;
        }
        long frameTimeInMs = this.mCurrentTime / framesCount;
        int i = 1;
        while ((long)i <= framesCount) {
            this.onUpdate(frameTimeInMs * (long)i + 1L);
            ++i;
        }
    }

    private static class ParticleTimerTask
    extends TimerTask {
        private final WeakReference<ParticleSystem> mPs;

        ParticleTimerTask(ParticleSystem ps) {
            this.mPs = new WeakReference<ParticleSystem>(ps);
        }

        @Override
        public void run() {
            if (this.mPs.get() != null) {
                ParticleSystem ps = (ParticleSystem)this.mPs.get();
                ps.onUpdate(ps.mCurrentTime);
                ParticleSystem particleSystem = ps;
                particleSystem.mCurrentTime = particleSystem.mCurrentTime + ps.mUpdateInterval;
            }
        }
    }
}

