/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;

public class Logc {
    public static final String LINE_BREAK = "\r\n";
    private static final ThreadLocal<ReusableFormatter> thread_local_formatter = new ThreadLocal<ReusableFormatter>(){

        @Override
        protected ReusableFormatter initialValue() {
            return new ReusableFormatter();
        }
    };
    public static boolean isWriteAll = false;
    public static boolean isWriteInfo = false;
    public static boolean isWriteDebug = false;
    public static boolean isWriteError = false;
    public static boolean isWriteVerbose = false;
    public static boolean isWriteWarm = false;
    public static boolean isAndroid = true;
    public static String ROOT;
    public static String TAG;
    public static boolean DEBUG;
    public static boolean allowD;
    public static boolean allowE;
    public static boolean allowI;
    public static boolean allowV;
    public static boolean allowW;
    private static String PATH_LOG_INFO;
    public static ILogger logger;

    public static void write(boolean on) {
        isWriteAll = on;
    }

    private static void showLog(String text) {
        if (logger != null) {
            logger.show(text);
        }
    }

    public static void init(Context context) {
        PATH_LOG_INFO = Environment.getExternalStorageDirectory().getPath() + File.separator + context.getPackageName() + File.separator + "log/";
    }

    private static void loge(String tag, String content, Throwable tr) {
        if (isAndroid) {
            if (content != null) {
                Log.e((String)tag, (String)content, (Throwable)tr);
                if (isWriteAll || isWriteError) {
                    Logc.point(PATH_LOG_INFO, tag, content);
                }
            }
        } else {
            System.err.println(tag + "-" + content);
        }
        Logc.showLog(tag + "-" + content);
    }

    private static void logd(String tag, String content) {
        if (isAndroid) {
            if (content != null) {
                Log.d((String)tag, (String)content);
                if (isWriteAll || isWriteDebug) {
                    Logc.point(PATH_LOG_INFO, tag, content);
                }
            }
        } else {
            System.out.println(tag + "-" + content);
        }
        Logc.showLog(tag + "-" + content);
    }

    private static void logw(String tag, String content) {
        if (isAndroid) {
            if (content != null) {
                Log.w((String)tag, (String)content);
                if (isWriteAll || isWriteWarm) {
                    Logc.point(PATH_LOG_INFO, tag, content);
                }
            }
        } else {
            System.out.println(tag + "-" + content);
        }
        Logc.showLog(tag + "-" + content);
    }

    private static void logi(String tag, String content) {
        if (isAndroid) {
            if (content != null) {
                Log.i((String)tag, (String)content);
                if (isWriteAll || isWriteInfo) {
                    Logc.point(PATH_LOG_INFO, tag, content);
                }
            }
        } else {
            System.out.println(tag + "-" + content);
        }
        Logc.showLog(tag + "-" + content);
    }

    private static void logv(String tag, String content) {
        if (isAndroid) {
            if (content != null) {
                Log.v((String)tag, (String)content);
                if (isWriteAll || isWriteVerbose) {
                    Logc.point(PATH_LOG_INFO, tag, content);
                }
            }
        } else {
            System.out.println(tag + "-" + content);
        }
        Logc.showLog(tag + "-" + content);
    }

    public static void v(String content) {
        if (isAndroid) {
            if (!allowV) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, null);
            Logc.logv(tag, content);
        } else {
            Logc.v(null, content, false);
        }
    }

    public static void v(String content, boolean isSaveLog) {
        if (isAndroid) {
            if (!allowV) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, null);
            Logc.logv(tag, content);
            if (isSaveLog && isAndroid) {
                Logc.point(PATH_LOG_INFO, tag, content);
            }
        } else {
            Logc.v(null, content, isSaveLog);
        }
    }

    public static void v(String uTag, String content) {
        if (isAndroid) {
            if (!allowV) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, uTag);
            Logc.logv(tag, content);
        } else {
            Logc.v(uTag, content, false);
        }
    }

    public static void v(String uTag, String content, boolean isSaveLog) {
        if (!allowV) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, uTag);
        Logc.logv(tag, content);
        if (isSaveLog && isAndroid || isWriteAll) {
            Logc.point(PATH_LOG_INFO, tag, content);
        }
    }

    public static void v(String content, Throwable tr) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, null);
        Log.v((String)tag, (String)content, (Throwable)tr);
        if (isWriteAll || isWriteVerbose) {
            Logc.point(PATH_LOG_INFO, tag, Logc.getThrowable(tr, content));
        }
    }

    public static void d(String content) {
        if (isAndroid) {
            if (!allowD) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, null);
            Logc.logd(tag, content);
        } else {
            Logc.d(null, content, false);
        }
    }

    public static void d(String content, boolean isSaveLog) {
        if (isAndroid) {
            if (!allowD) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, null);
            Logc.logd(tag, content);
            if (isSaveLog && isAndroid) {
                Logc.point(PATH_LOG_INFO, tag, content);
            }
        } else {
            Logc.d(null, content, isSaveLog);
        }
    }

    public static void d(String uTag, String content) {
        if (isAndroid) {
            if (!allowD) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, uTag);
            Logc.logd(tag, content);
        } else {
            Logc.d(uTag, content, false);
        }
    }

    public static void d(String uTag, String content, boolean isSaveLog) {
        if (!allowD) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, uTag);
        Logc.logd(tag, content);
        if (isSaveLog && isAndroid || isWriteAll) {
            Logc.point(PATH_LOG_INFO, tag, content);
        }
    }

    public static void d(String content, Throwable tr) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, null);
        Log.d((String)tag, (String)content, (Throwable)tr);
        if (isWriteAll || isWriteDebug) {
            Logc.point(PATH_LOG_INFO, tag, Logc.getThrowable(tr, content));
        }
    }

    public static void i(String content) {
        if (isAndroid) {
            if (!allowI) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, null);
            Logc.logi(tag, content);
        } else {
            Logc.i(null, content, false);
        }
    }

    public static void i(String content, Throwable tr) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, null);
        Log.i((String)tag, (String)content, (Throwable)tr);
        if (isWriteAll || isWriteInfo) {
            Logc.point(PATH_LOG_INFO, tag, Logc.getThrowable(tr, content));
        }
    }

    public static void i(String content, boolean isSaveLog) {
        Logc.i(null, content, isSaveLog);
    }

    public static void i(String uTag, String content) {
        if (isAndroid) {
            if (!allowI) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, uTag);
            Logc.logi(tag, content);
        } else {
            Logc.i(uTag, content, false);
        }
    }

    public static void i(String uTag, String content, boolean isSaveLog) {
        if (!allowI) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, uTag);
        Logc.logi(tag, content);
        if (isSaveLog && isAndroid || isWriteAll) {
            Logc.point(PATH_LOG_INFO, tag, content);
        }
    }

    public static void w(String content) {
        if (isAndroid) {
            if (!allowW) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, null);
            Logc.logw(tag, content);
        } else {
            Logc.w(null, content, false);
        }
    }

    public static void w(String content, boolean isSaveLog) {
        if (isAndroid) {
            if (!allowW) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, null);
            Logc.logw(tag, content);
            if (isSaveLog && isAndroid) {
                Logc.point(PATH_LOG_INFO, tag, content);
            }
        } else {
            Logc.w(null, content, isSaveLog);
        }
    }

    public static void w(String uTag, String content) {
        if (isAndroid) {
            if (!allowW) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, uTag);
            Logc.logw(tag, content);
        } else {
            Logc.w(null, content, false);
        }
    }

    public static void w(String uTag, String content, boolean isSaveLog) {
        if (!allowW) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, uTag);
        Logc.logw(tag, content);
        if (isSaveLog && isAndroid || isWriteAll) {
            Logc.point(PATH_LOG_INFO, tag, content);
        }
    }

    public static void w(String content, Throwable tr) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, null);
        Log.w((String)tag, (String)content, (Throwable)tr);
        if (isWriteAll || isWriteWarm) {
            Logc.point(PATH_LOG_INFO, tag, Logc.getThrowable(tr, content));
        }
    }

    public static void e(String content) {
        if (isAndroid) {
            if (!allowE) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, null);
            Logc.loge(tag, content, null);
        } else {
            Logc.w(null, content, false);
        }
    }

    public static void e(String content, boolean isSaveLog) {
        if (isAndroid) {
            if (!allowE) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, null);
            Logc.loge(tag, content, null);
            if (isSaveLog && isAndroid) {
                Logc.point(PATH_LOG_INFO, tag, content);
            }
        } else {
            Logc.w(null, content, isSaveLog);
        }
    }

    public static void e(String uTag, String content) {
        if (isAndroid) {
            if (!allowE) {
                return;
            }
            StackTraceElement caller = Logc.getCallerStackTraceElement();
            String tag = Logc.generateTag(caller, uTag);
            Logc.loge(tag, content, null);
        } else {
            Logc.w(uTag, content, false);
        }
    }

    public static void e(String uTag, String content, boolean isSaveLog) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, uTag);
        Logc.loge(tag, content, null);
        if (isSaveLog && isAndroid || isWriteAll) {
            Logc.point(PATH_LOG_INFO, tag, content);
        }
    }

    public static void e(String content, Throwable tr) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, null);
        Log.e((String)tag, (String)content, (Throwable)tr);
        if (isWriteAll || isWriteError) {
            Logc.point(PATH_LOG_INFO, tag, Logc.getThrowable(tr, content));
        }
    }

    public static void e(String uTag, String content, Throwable tr) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, uTag);
        Log.e((String)tag, (String)content, (Throwable)tr);
    }

    public static void e(String content, Throwable tr, boolean isSaveLog) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, null);
        Log.e((String)tag, (String)content, (Throwable)tr);
        if (isSaveLog && isAndroid || isWriteAll) {
            Logc.point(PATH_LOG_INFO, tag, Logc.getThrowable(tr, content));
        }
    }

    public static void e(Throwable tr, boolean isSaveLog) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, null);
        String content = Logc.getThrowable(tr, null);
        Logc.loge(tag, content, null);
        if (isSaveLog && isAndroid || isWriteAll) {
            Logc.point(PATH_LOG_INFO, tag, content);
        }
    }

    public static void e(Throwable tr) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, null);
        String content = Logc.getThrowable(tr, null);
        Logc.loge(tag, content, null);
    }

    public static void e(String uTag, String content, Throwable tr, boolean isSaveLog) {
        if (!allowE) {
            return;
        }
        StackTraceElement caller = Logc.getCallerStackTraceElement();
        String tag = Logc.generateTag(caller, uTag);
        Logc.loge(tag, content, tr);
        String msg = Logc.getThrowable(tr, content);
        if (isSaveLog && isAndroid || isWriteAll) {
            Logc.point(PATH_LOG_INFO, tag, msg);
        }
    }

    private static StackTraceElement getCallerStackTraceElement() {
        return Thread.currentThread().getStackTrace()[4];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void point(String path, String tag, String msg) {
        if (Logc.isSDAva()) {
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("", Locale.SIMPLIFIED_CHINESE);
            dateFormat.applyPattern("yyyy");
            path = path + dateFormat.format(date) + "/";
            dateFormat.applyPattern("MM");
            path = path + dateFormat.format(date) + "/";
            dateFormat.applyPattern("dd");
            path = path + dateFormat.format(date) + ".log";
            dateFormat.applyPattern("[yyyy-MM-dd HH:mm:ss]");
            String time = dateFormat.format(date);
            File file = new File(path);
            if (!file.exists()) {
                Logc.createDipPath(path);
            }
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));
                out.write(time + " " + tag + " " + msg + LINE_BREAK);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void createDipPath(String file) {
        String parentFile = file.substring(0, file.lastIndexOf("/"));
        File file1 = new File(file);
        File parent = new File(parentFile);
        if (!file1.exists()) {
            parent.mkdirs();
            try {
                file1.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String format(String msg, Object ... args) {
        ReusableFormatter formatter = thread_local_formatter.get();
        return formatter.format(msg, args);
    }

    public static boolean isSDAva() {
        return isAndroid && Environment.getExternalStorageState().equals("mounted") || Environment.getExternalStorageDirectory().exists();
    }

    private static String generateTag(StackTraceElement caller, String uTag) {
        String tag = "(%s:%d).%s";
        String callerClazzName = caller.getFileName();
        String str = tag = String.format(tag, callerClazzName, caller.getLineNumber(), caller.getMethodName());
        str = uTag == null || uTag.equals("") ? TAG + ":" + tag : TAG + "." + uTag + ":" + tag;
        return str;
    }

    private static String getThrowable(Throwable throwable, String mag) {
        StringBuffer sb = new StringBuffer();
        if (!TextUtils.isEmpty((CharSequence)mag)) {
            sb.append(mag);
        }
        if (throwable != null) {
            sb.append(LINE_BREAK);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            sb.append(stringWriter.toString());
        }
        return sb.toString();
    }

    static {
        TAG = "uu_clife";
        DEBUG = true;
        allowD = DEBUG;
        allowE = DEBUG;
        allowI = DEBUG;
        allowV = DEBUG;
        allowW = DEBUG;
        String os = System.getProperty("os.name");
        boolean isdebug = false;
        System.out.println("uu_clife current os System is " + os + ",isdebug:" + isdebug);
        if (os.toLowerCase().contains("win") || os.toLowerCase().contains("mac")) {
            isAndroid = false;
        } else {
            ROOT = Environment.getExternalStorageDirectory().getPath() + "/hetgateway/";
            PATH_LOG_INFO = ROOT + "log/";
            isAndroid = true;
        }
    }

    public static interface ILogger {
        public void show(String var1);
    }

    private static class ReusableFormatter {
        private Formatter formatter;
        private StringBuilder builder = new StringBuilder();

        public ReusableFormatter() {
            this.formatter = new Formatter(this.builder);
        }

        public String format(String msg, Object ... args) {
            this.formatter.format(msg, args);
            String s = this.builder.toString();
            this.builder.setLength(0);
            return s;
        }
    }
}

