/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.db;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.het.xml.protocol.db.DatabaseHelper;
import com.het.xml.protocol.db.DeviceProtocolModel;
import java.util.ArrayList;
import java.util.List;

public class DeviceProtocolDao {
    private SQLiteDatabase mDb;

    public DeviceProtocolDao(Context ctx) {
        this.mDb = DatabaseHelper.getDatabase(ctx);
    }

    public List<DeviceProtocolModel> loadAll() {
        Cursor cursor = this.mDb.query("protocolxml", DeviceProtocolModel.COLUMNS, null, null, null, null, null);
        ArrayList<DeviceProtocolModel> list = new ArrayList<DeviceProtocolModel>();
        DeviceProtocolModel model = null;
        while (cursor.moveToNext()) {
            model = DeviceProtocolModel.parse(cursor);
            list.add(model);
        }
        cursor.close();
        return list;
    }

    public DeviceProtocolModel get(int productId) {
        String strSelection = "productId = ?";
        String[] strSelectionArgs = new String[]{String.valueOf(productId)};
        Cursor cursor = this.mDb.query("protocolxml", DeviceProtocolModel.COLUMNS, strSelection, strSelectionArgs, null, null, null);
        DeviceProtocolModel model = null;
        if (cursor.moveToFirst()) {
            model = DeviceProtocolModel.parse(cursor);
        }
        cursor.close();
        return model;
    }

    public boolean save(DeviceProtocolModel model) {
        DeviceProtocolModel existModel = this.get(model.getProductId());
        boolean bIsSuccess = false;
        long lRowId = -1L;
        lRowId = existModel == null ? this.mDb.insert("protocolxml", null, model.toContentValues()) : (long)this.update(model);
        if (lRowId != -1L) {
            bIsSuccess = true;
        }
        return bIsSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(DeviceProtocolModel model) {
        int iRowId = -1;
        try {
            this.mDb.beginTransaction();
            int strUserId = model.getProductId();
            String strWhereClause = "productId = ?";
            String[] strWhereArgs = new String[]{String.valueOf(strUserId)};
            iRowId = this.mDb.update("protocolxml", model.toContentValues(), strWhereClause, strWhereArgs);
            if (iRowId != -1) {
                this.mDb.setTransactionSuccessful();
            }
        }
        finally {
            this.mDb.endTransaction();
        }
        return iRowId;
    }

    public boolean insert(DeviceProtocolModel deviceProtocolModel) {
        boolean bIsSuccess = true;
        try {
            this.mDb.beginTransaction();
            bIsSuccess = this.save(deviceProtocolModel);
            if (bIsSuccess) {
                this.mDb.setTransactionSuccessful();
            }
        }
        finally {
            this.mDb.endTransaction();
        }
        return bIsSuccess;
    }
}

