/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private static DatabaseHelper sDbHelper;
    private static SQLiteDatabase sDb;
    private static Context sContext;
    private static Object sObjLock;

    private DatabaseHelper(Context context) {
        super(context, "protocol.db", null, 10);
        sContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DatabaseHelper getInstance(Context context) {
        if (sDbHelper == null) {
            Object object = sObjLock;
            synchronized (object) {
                if (sDbHelper == null) {
                    sDbHelper = new DatabaseHelper(context);
                }
            }
        }
        return sDbHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLiteDatabase getDatabase(Context context) {
        if (sDb == null) {
            Object object = sObjLock;
            synchronized (object) {
                if (sDb == null) {
                    sDb = DatabaseHelper.getInstance(context).getWritableDatabase();
                }
            }
        } else {
            while (sDb.isDbLockedByCurrentThread() || sDb.isDbLockedByCurrentThread()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return sDb;
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE protocolxml (_id INTEGER PRIMARY KEY AUTOINCREMENT, productId INTEGER, protocolDate TEXT, protocolId TEXT, base64data TEXT, update_time TEXT);");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < newVersion) {
            db.execSQL("DROP TABLE IF EXISTS 'protocolxml'");
            this.onCreate(db);
        }
    }

    static {
        sObjLock = new Object();
    }
}

