/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.utils;

import com.het.xml.protocol.coder.bean.ByteDefinition;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Pattern;

public class StringUtil {
    public static Object caclSigned(Object value, ByteDefinition element) {
        if (element == null) {
            return null;
        }
        Integer signed = element.getIsSigned();
        if (signed == null) {
            return null;
        }
        if (signed != 1) {
            return null;
        }
        switch (element.getLength()) {
            case 1: {
                int tmpByte = Integer.valueOf(value.toString());
                byte cByte = StringUtil.binaryToDecimal8(tmpByte);
                return cByte;
            }
            case 2: {
                int tmpShort = Integer.valueOf(value.toString());
                short cShort = StringUtil.binaryToDecimal16(tmpShort);
                return cShort;
            }
            case 4: {
                int tmpInt = Integer.valueOf(value.toString());
                int cInt = StringUtil.binaryToDecimal32(tmpInt);
                return cInt;
            }
            case 8: {
                int tmpLong = Integer.valueOf(value.toString());
                long cLong = StringUtil.binaryToDecimal64(tmpLong);
                return cLong;
            }
        }
        return null;
    }

    public static byte binaryToDecimal8(long n) {
        byte value = 0;
        for (int i = 7; i >= 0; --i) {
            long t = n >>> i & 1L;
            System.out.print(t);
            long tmp = t << i;
            value = (byte)((long)value | tmp);
        }
        return value;
    }

    public static short binaryToDecimal16(long n) {
        short value = 0;
        for (int i = 15; i >= 0; --i) {
            long t = n >>> i & 1L;
            System.out.print(t);
            long tmp = t << i;
            value = (short)((long)value | tmp);
        }
        return value;
    }

    public static int binaryToDecimal32(long n) {
        int value = 0;
        for (int i = 15; i >= 0; --i) {
            long t = n >>> i & 1L;
            System.out.print(t);
            long tmp = t << i;
            value = (int)((long)value | tmp);
        }
        return value;
    }

    public static long binaryToDecimal64(long n) {
        long value = 0L;
        for (int i = 15; i >= 0; --i) {
            long t = n >>> i & 1L;
            System.out.print(t);
            long tmp = t << i;
            value |= tmp;
        }
        return value;
    }

    public static byte[] hexString2Bytes(String src) {
        int l = src.length() / 2;
        byte[] ret = new byte[l];
        for (int i = 0; i < l; ++i) {
            ret[i] = Integer.valueOf(src.substring(i * 2, i * 2 + 2), 16).byteValue();
        }
        return ret;
    }

    public static String byteToMac(byte[] resBytes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < resBytes.length; ++i) {
            String hex = Integer.toHexString(resBytes[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            buffer.append(hex.toUpperCase());
        }
        return buffer.toString();
    }

    public static boolean isNum(String strNum) {
        return strNum.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(StringUtil.charToByte(hexChars[pos]) << 4 | StringUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static <T> String join(T[] objs, String splitString) {
        return StringUtil.join(objs, 0, objs.length, splitString);
    }

    public static <T> String join(T[] objs, int start, int end, String splitString) {
        StringBuilder s = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (i != start) {
                s.append(splitString);
            }
            s.append(objs[i]);
        }
        return s.toString();
    }

    public static String join(List<?> objList, String splitString) {
        return StringUtil.join(objList, 0, objList.size(), splitString);
    }

    public static String join(List<?> objList, int start, int end, String splitString) {
        StringBuilder s = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (i != start) {
                s.append(splitString);
            }
            s.append(objList.get(i));
        }
        return s.toString();
    }

    public static <T> String join(List<T[]> objList, int columnIndex, String splitString) {
        StringBuilder s = new StringBuilder();
        if (objList.size() > 0) {
            s.append(objList.get(0)[columnIndex]);
            int ii = objList.size();
            for (int i = 1; i < ii; ++i) {
                s.append(splitString).append(objList.get(i)[columnIndex]);
            }
        }
        return s.toString();
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            throw new NullPointerException("\u91cd\u590d\u7684\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3anull\u3002");
        }
        if (repeat < 0) {
            throw new IllegalArgumentException("\u91cd\u590d\u7684\u6b21\u6570(" + repeat + ")\u5c0f\u4e8e\u5e95\u96500\u3002");
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < repeat; ++i) {
            s.append(str);
        }
        return s.toString();
    }

    public static boolean equals(String string, String another) {
        if (string != null) {
            return string.equals(another);
        }
        if (another != null) {
            return another.equals(string);
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String string, String another) {
        if (string != null) {
            return string.equalsIgnoreCase(another);
        }
        if (another != null) {
            return another.equalsIgnoreCase(string);
        }
        return true;
    }

    public static boolean contains(String strToFind, String ... strings) {
        for (String s : strings) {
            if (!StringUtil.equals(s, strToFind)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String strToFind, String ... strings) {
        for (String s : strings) {
            if (!StringUtil.equalsIgnoreCase(s, strToFind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmptyAny(String ... ss) {
        for (String s : ss) {
            if (!StringUtil.isEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyAll(String ... ss) {
        for (String s : ss) {
            if (!StringUtil.isNotEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean isNotEmptyAny(String ... ss) {
        for (String s : ss) {
            if (!StringUtil.isNotEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmptyAll(String ... ss) {
        for (String s : ss) {
            if (!StringUtil.isEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static void checkEmpty(String s) {
        if (StringUtil.isEmpty(s)) {
            throw new IllegalStateException();
        }
    }

    public static void checkEmpty(String s, String msg) {
        if (StringUtil.isEmpty(s)) {
            throw new IllegalStateException(msg);
        }
    }

    public static void checkNull(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    public static void checkNull(Object o, String msg) {
        if (o == null) {
            throw new NullPointerException(msg);
        }
    }

    public static byte[] getBytes(String s, String charset) {
        try {
            return s.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] getBytes(String s, Charset charset) {
        return s.getBytes(charset);
    }

    public static String getString(byte[] bytes, String charset) {
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getString(byte[] bytes, Charset charset) {
        return new String(bytes, charset);
    }

    public static byte[] hexStringToByteArray(String hexString) {
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("16\u8fdb\u5236\u6570\u636e\u957f\u5ea6\u4e0d\u4e3a2\u7684\u500d\u6570\uff1a" + hexString);
        }
        StringReader stringReader = new StringReader(hexString);
        byte[] bytes = new byte[hexString.length() / 2];
        char[] chars = new char[2];
        try {
            int i = 0;
            while (stringReader.read(chars) != -1) {
                bytes[i] = (byte)Integer.parseInt(String.valueOf(chars), 16);
                ++i;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return bytes;
    }

    public static String stringToHexString(String string, String charset) {
        byte[] bytes = StringUtil.getBytes(string, charset);
        return StringUtil.byteArrayToHexString(bytes);
    }

    public static String stringToHexString(String string, Charset charset) {
        byte[] bytes = StringUtil.getBytes(string, charset);
        return StringUtil.byteArrayToHexString(bytes);
    }

    public static String byteArrayToHexString(byte[] bytes) {
        Formatter fmt = new Formatter(new StringBuilder(bytes.length * 2));
        for (byte b : bytes) {
            fmt.format("%02x", b);
        }
        return fmt.toString().toUpperCase();
    }

    public static boolean isDigit(String s) {
        return s.matches("^\\d+$");
    }

    public static boolean isAlpha(String s) {
        return s.matches("^[a-zA-Z]+$");
    }

    public static boolean isUpper(String s) {
        return s.matches("^[A-Z]+$");
    }

    public static boolean isLower(String s) {
        return s.matches("^[a-z]+$");
    }

    public static boolean isAlnum(String s) {
        return s.matches("^[a-zA-Z\\d]+$");
    }

    public static boolean isInt(String s) {
        return s.matches("^[+-]?\\d+$");
    }

    public static boolean isFloat(String s) {
        return s.matches("^[+-]?(0\\.\\d+|0|[1-9]\\d*(\\.\\d+)?)$");
    }

    static boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isEmail(String s) {
        return s.matches("^[a-zA-Z0-9._-]+@([a-zA-Z0-9_-])+(\\.[a-zA-Z0-9_-]+)+$");
    }

    public static boolean isIP(String s) {
        return s.matches("^(0?0?[1-9]|0?[1-9]\\d|1\\d\\d|2[01]\\d|22[0-3])(\\.([01]?\\d?\\d|2[0-4]\\d|25[0-5])){3}$");
    }

    public static String byteArrayToHexZeroString(byte[] bytes) {
        Formatter fmt = new Formatter(new StringBuilder(bytes.length * 2));
        for (byte b : bytes) {
            if (b == 0) continue;
            fmt.format("%02x", b);
        }
        return fmt.toString();
    }

    public static String capitalize(String str) {
        return StringUtil.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringUtil.changeFirstCharacterCase(str, false);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        if (capitalize) {
            sb.append(Character.toUpperCase(str.charAt(0)));
        } else {
            sb.append(Character.toLowerCase(str.charAt(0)));
        }
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String getFileName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static boolean isInteger1(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isInteger(String str) {
        try {
            BigDecimal bigDecimal = new BigDecimal(str);
            return true;
        }
        catch (Exception e) {
            if (e != null) {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
            return false;
        }
    }

    public static void main(String[] args) {
        byte[] rr = StringUtil.hexStringToByteArray("0b");
    }
}

