/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.utils;

import java.math.BigDecimal;
import java.math.BigInteger;

public class BinaryConvertUtils {
    public static byte[] longToByteArray(long val, int size) {
        byte[] result = new byte[size];
        for (int j = 0; j < size; ++j) {
            result[j] = (byte)(val >>> 8 * (size - j - 1) & 0xFFL);
        }
        return result;
    }

    public static byte[] floatToByteArray(float val) {
        int temVal = Float.floatToIntBits(val);
        int size = 32;
        byte[] result = new byte[size];
        for (int j = 0; j < size; ++j) {
            result[j] = (byte)(temVal >>> 8 * (size - j - 1) & 0xFF);
        }
        return result;
    }

    public static float byteArrayToFloat(byte[] bytes) {
        if (bytes.length != 32) {
            throw new IllegalArgumentException("byte array length must be 32");
        }
        return Float.intBitsToFloat((int)BinaryConvertUtils.byteArrayToLong(bytes));
    }

    public static double byteArrayToDouble(byte[] bytes) {
        if (bytes.length != 64) {
            throw new IllegalArgumentException("byte array length must be 64");
        }
        return Double.longBitsToDouble(BinaryConvertUtils.byteArrayToLong(bytes));
    }

    public static byte[] doubleToByteArray(double val) {
        long temVal = Double.doubleToLongBits(val);
        int size = 64;
        byte[] result = new byte[size];
        for (int j = 0; j < size; ++j) {
            result[j] = (byte)(temVal >>> 8 * (size - j - 1) & 0xFFL);
        }
        return result;
    }

    public static long byteArrayToLong(byte[] bytes) {
        int size = bytes.length;
        long val = 0L;
        for (int j = 0; j < size; ++j) {
            val += (long)(bytes[j] & 0xFF) << 8 * (size - j - 1);
        }
        return val;
    }

    public static void main(String[] args) {
        byte[] da = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        long lo = BinaryConvertUtils.byteArrayToLong(da);
        int i = (int)lo;
        short s = (short)lo;
        for (int j = 0; j < 100; ++j) {
            int k = j % 2;
            int v = j / 2;
            if (k != 0) continue;
        }
    }

    public static Number convertNumberToTargetClass(Number number, Class targetClass) throws IllegalArgumentException {
        if (targetClass.isInstance(number)) {
            return number;
        }
        if (targetClass.equals(Byte.class)) {
            long value = number.longValue();
            if (value < -128L || value > 127L) {
                BinaryConvertUtils.raiseOverflowException(number, targetClass);
            }
            return new Byte(number.byteValue());
        }
        if (targetClass.equals(Short.class)) {
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                BinaryConvertUtils.raiseOverflowException(number, targetClass);
            }
            return new Short(number.shortValue());
        }
        if (targetClass.equals(Integer.class)) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                BinaryConvertUtils.raiseOverflowException(number, targetClass);
            }
            return new Integer(number.intValue());
        }
        if (targetClass.equals(Long.class)) {
            return new Long(number.longValue());
        }
        if (targetClass.equals(BigInteger.class)) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(Float.class)) {
            return new Float(number.floatValue());
        }
        if (targetClass.equals(Double.class)) {
            return new Double(number.doubleValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class<?> targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }
}

