/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.parse;

import com.het.xml.protocol.coder.DataTypeDefinition;
import com.het.xml.protocol.coder.bean.ByteDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.parse.ProductorProtocolList;
import com.het.xml.protocol.coder.parse.ProtocolFileLoadManager;
import com.het.xml.protocol.utils.Logc;
import com.thoughtworks.xstream.XStreamException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ProductorProtocolManager
extends ProtocolFileLoadManager {
    private final HashMap<String, ProductorProtocolList> productModelMapper = new HashMap(50);
    private final HashMap<String, ProductorProtocolList> developModelMapper = new HashMap(50);
    private ReentrantReadWriteLock productLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock developLock = new ReentrantReadWriteLock();

    public ProtocolDefinition get(String developerID, String protocolID, int mode) {
        if (developerID == null || protocolID == null) {
            throw new IllegalArgumentException("developerID\u6216\u8005protocolID\u53c2\u6570\u4e0d\u80fd\u4e3aNULL");
        }
        ProtocolDefinition definition = null;
        ProductorProtocolList protocolList = null;
        if (mode == 0) {
            protocolList = this.getFromDevelopModelList(developerID);
            if (protocolList != null) {
                definition = (ProtocolDefinition)protocolList.get(protocolID);
            }
        } else if (mode == 1 && (protocolList = this.getFromProductModelList(developerID)) != null) {
            definition = (ProtocolDefinition)protocolList.get(protocolID);
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProductorProtocolList getFromDevelopModelList(String developerID) {
        ReentrantReadWriteLock.ReadLock readLock = this.developLock.readLock();
        readLock.lock();
        try {
            ProductorProtocolList productorProtocolList = this.developModelMapper.get(developerID.toUpperCase());
            return productorProtocolList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProductorProtocolList getFromProductModelList(String developerID) {
        ReentrantReadWriteLock.ReadLock readLock = this.productLock.readLock();
        readLock.lock();
        try {
            ProductorProtocolList productorProtocolList = this.productModelMapper.get(developerID.toUpperCase());
            return productorProtocolList;
        }
        finally {
            readLock.unlock();
        }
    }

    private void put(String developerID, String protocolID, Object definition, int model) {
        if (developerID == null || definition == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3aNULL");
        }
        if (model == 0) {
            this.saveInDevelopModelList(developerID, protocolID, definition);
        } else if (model == 1) {
            this.saveInProductModelList(developerID, protocolID, definition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInDevelopModelList(String developerID, String protocolID, Object definition) {
        if (developerID == null || definition == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3aNULL");
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.developLock.writeLock();
        writeLock.lock();
        try {
            developerID = developerID.toUpperCase();
            ProductorProtocolList protocolList = this.developModelMapper.get(developerID);
            if (protocolList == null) {
                protocolList = new ProductorProtocolList();
                this.developModelMapper.put(developerID, protocolList);
            }
            protocolList.put(protocolID, definition);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInProductModelList(String developerID, String protocolID, Object definition) {
        if (developerID == null || definition == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3aNULL");
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.productLock.writeLock();
        writeLock.lock();
        try {
            developerID = developerID.toUpperCase();
            ProductorProtocolList protocolList = this.productModelMapper.get(developerID);
            if (protocolList == null) {
                protocolList = new ProductorProtocolList();
                this.productModelMapper.put(developerID, protocolList);
            }
            protocolList.put(protocolID, definition);
        }
        finally {
            writeLock.unlock();
        }
    }

    public ProtocolDefinition load(String xml, String developerID, String protocolID, int mode) {
        ProtocolDefinition definition = null;
        try {
            definition = (ProtocolDefinition)this.getParser().paseXML(xml);
            int packetSize = this.calculate(definition);
            definition.setPacketSize(packetSize);
            this.put(developerID, protocolID, definition, mode);
        }
        catch (XStreamException e) {
            e.printStackTrace();
        }
        Logc.e("[\u5f00\u53d1\u8005ID\uff1a{}   \u534f\u8baeID\uff1a{}]-{}\u534f\u8bae\u52a0\u8f7d\u6210\u529f" + developerID + protocolID + (mode == 0 ? "\u5f00\u53d1\u6a21\u5f0f" : "\u751f\u4ea7\u6a21\u5f0f"));
        return definition;
    }

    private int calculate(ProtocolDefinition protocolDenifition) {
        List<ByteDefinition> byteList;
        int size = 0;
        if (protocolDenifition != null && (byteList = protocolDenifition.getByteDefList()) != null) {
            for (ByteDefinition byteDef : byteList) {
                if (byteDef.getBitDefList() != null) {
                    ++size;
                    continue;
                }
                size += byteDef.getLength() != null ? byteDef.getLength().intValue() : DataTypeDefinition.getDataType(byteDef.getJavaType()).getSize();
            }
        }
        return size;
    }

    public void remove(String developerID, String protocolID) {
        try {
            Object obj = this.removeFromDevelopModelList(developerID, protocolID);
            if (obj == null) {
                obj = this.removeFromProductModelList(developerID, protocolID);
            }
            Logc.e("[\u5f00\u53d1\u8005ID:{} \u534f\u8baeID:{}]-\u79fb\u9664\u5f00\u53d1\u8005\u534f\u8bae{}" + developerID + protocolID + (obj == null ? "\u5931\u8d25" : "\u6210\u529f"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(String developerID, String protocolID, int mode) {
        try {
            Object obj = null;
            if (mode == 0) {
                obj = this.removeFromDevelopModelList(developerID, protocolID);
            } else if (mode == 1) {
                obj = this.removeFromProductModelList(developerID, protocolID);
            }
            Logc.e("[\u5f00\u53d1\u8005ID:{} \u534f\u8baeID:{}]-\u79fb\u9664{}\u534f\u8bae{}" + developerID + protocolID + (mode == 0 ? "\u5f00\u53d1\u6a21\u5f0f" : "\u751f\u4ea7\u6a21\u5f0f") + (obj == null ? "\u5931\u8d25" : "\u6210\u529f"));
        }
        catch (Exception e) {
            Logc.e("[\u5f00\u53d1\u8005ID:{} \u534f\u8baeID:{}]-\u5f02\u5e38\uff1a\u79fb\u9664\u5f00\u53d1\u8005\u534f\u8bae\u5931\u8d25(\u5931\u8d25\u539f\u56e0\uff1a{})" + new Object[]{developerID, protocolID, e.getMessage()});
        }
    }

    private Object removeFromDevelopModelList(String developerID, String protocolID) {
        Object definition = null;
        ProductorProtocolList protocolList = null;
        try {
            protocolList = this.getFromDevelopModelList(developerID);
            if (protocolList != null) {
                definition = protocolList.remove(protocolID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return definition;
    }

    private Object removeFromProductModelList(String developerID, String protocolID) {
        Object definition = null;
        ProductorProtocolList protocolList = null;
        try {
            protocolList = this.getFromProductModelList(developerID);
            if (protocolList != null) {
                definition = protocolList.remove(protocolID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return definition;
    }
}

