/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.encode;

import android.text.TextUtils;
import com.het.xml.protocol.coder.bean.BaseDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.encode.AbstractEncoder;
import com.het.xml.protocol.coder.exception.EncodeException;
import com.het.xml.protocol.coder.utils.BinaryConvertUtils;
import com.het.xml.protocol.coder.utils.StringUtil;
import com.het.xml.protocol.utils.Logc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SecondLayerProtocolEncoder
extends AbstractEncoder {
    @Override
    public byte[] encode(Object data) throws Exception {
        StringBuilder sb;
        String command = "";
        Object deviceType = null;
        Object deviceSubType = null;
        Object dataVersion = null;
        Object productId = null;
        if (data instanceof Map) {
            Map dto = (Map)data;
            command = StringUtil.byteArrayToHexString(BinaryConvertUtils.longToByteArray(Integer.parseInt(dto.get("command").toString()), 2));
            dataVersion = dto.get("dataVersion");
            deviceType = dto.get("deviceType");
            deviceSubType = dto.get("deviceSubType");
            productId = dto.get("productId");
        }
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append((Object)dataVersion).append("-").append((Object)deviceType).append("-").append((Object)deviceSubType).append("-").append(command);
        String key = keyBuilder.toString();
        ProtocolDefinition protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        if (protocolDefinition == null) {
            key = dataVersion + "";
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            sb = new StringBuilder();
            sb.append("2").append("-").append((Object)deviceType).append("-").append((Object)deviceSubType).append("-").append(command);
            key = sb.toString();
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            sb = new StringBuilder();
            sb.append((Object)productId);
            sb.append("-");
            sb.append(command);
            key = sb.toString();
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            Logc.e("can't find the protocol configuration,protocolId=" + key);
            throw new EncodeException("<PROTOCOL_ID:" + key + "> can't find the protocol configuration");
        }
        byte[] tempData = null;
        try {
            HashMap<String, BaseDefinition> mapper = this.protocolXmlManager.get0104Mapper(key);
            if (mapper != null) {
                this.processUpdateFlag(data, mapper);
            }
        }
        catch (Exception e) {
            Logc.e("<PROTOCOL_ID=" + key + ">EXCEPTION=" + e);
        }
        try {
            tempData = this.encode(protocolDefinition, data);
        }
        catch (Exception e) {
            Logc.e("<PROTOCOL_ID=" + key + ">EXCEPTION=" + e);
            throw new EncodeException("PROTOCOL_ID=" + protocolDefinition.getId() + " exception=" + e.getMessage());
        }
        return tempData;
    }

    private void processUpdateFlag(Object data, HashMap<String, BaseDefinition> mapper) {
        if (data instanceof TreeMap) {
            TreeMap treeMap = (TreeMap)data;
            if (treeMap != null && treeMap.containsKey("updateFlag")) {
                return;
            }
            TreeMap dto = (TreeMap)data;
            String UPDATEFLAG_KAY = "updateFlag";
            BaseDefinition vv = mapper.get("updateFlag");
            if (vv != null) {
                int updateFlagLength = vv.getLength();
                Iterator keys = dto.keySet().iterator();
                if (keys != null) {
                    ArrayList<BaseDefinition> keyValye = new ArrayList<BaseDefinition>();
                    while (keys.hasNext()) {
                        BaseDefinition tmp;
                        String key = (String)keys.next();
                        if (key == null || key.equalsIgnoreCase("command") || key.equalsIgnoreCase("macAddress") || key.equalsIgnoreCase("deviceType") || key.equalsIgnoreCase("deviceSubType") || key.equalsIgnoreCase("dataVersion") || key.equalsIgnoreCase("updateFlag") || (tmp = mapper.get(key)) == null || tmp.getProperty() == null || !treeMap.containsKey(tmp.getProperty())) continue;
                        keyValye.add(tmp);
                    }
                    String flag = this.calcUpdateFlag(updateFlagLength, keyValye);
                    if (!TextUtils.isEmpty((CharSequence)flag)) {
                        dto.put("updateFlag", flag);
                    }
                }
            }
        }
    }

    public static void main(String[] ars) {
        String hex = "FFFFFFFFFFFFFFFFFF3F0000000000000000000000000000000000000000000000000";
        int len = hex.length() / 2;
        int[][] tmpInt = new int[len][8];
        for (int i = 0; i < len; ++i) {
        }
        String str = "000AB";
        Integer in = Integer.valueOf(str, 16);
        String st = Integer.toHexString(in).toUpperCase();
        st = String.format("%5s", st);
        st = st.replaceAll(" ", "0");
        System.out.println(st);
    }

    private String calcUpdateFlag(int updateFlagLen, List<BaseDefinition> keyValye) {
        if (updateFlagLen > 0 && keyValye != null && keyValye.size() > 0) {
            int[][] tempIntHigh = new int[updateFlagLen][8];
            byte[] updateFlag = new byte[updateFlagLen];
            for (int i = 0; i < keyValye.size(); ++i) {
                BaseDefinition bd = keyValye.get(i);
                if (bd == null) continue;
                int index = bd.getIndex();
                int len = bd.getLength();
                for (int k = index; k <= index + len - 1; ++k) {
                    tempIntHigh[k / 8][k % 8] = 1;
                }
            }
            for (int j = 0; j < tempIntHigh.length; ++j) {
                int[] tmpArr = tempIntHigh[j];
                byte des = 0;
                for (int l = tmpArr.length - 1; l >= 0; --l) {
                    if (tmpArr[l] != 1) continue;
                    int tmp = 1;
                    tmp = (byte)(tmp << l);
                    des = (byte)(des | tmp);
                }
                updateFlag[j] = des;
            }
            Logc.e("----------------------udpbb>" + Arrays.toString(updateFlag));
            String result = StringUtil.byteArrayToHexString(updateFlag);
            return result;
        }
        return null;
    }

    private String calcUpdateFlag1(int updateFlagLen, List<BaseDefinition> keyValye) {
        if (updateFlagLen > 0 && keyValye != null && keyValye.size() > 0) {
            boolean[] flag = new boolean[updateFlagLen * 8];
            byte[] updateFlag = new byte[updateFlagLen];
            for (int i = 0; i < keyValye.size(); ++i) {
                BaseDefinition bd = keyValye.get(i);
                if (bd == null) continue;
                int po = this.calcIndex(updateFlagLen, bd.getIndex());
                int len = bd.getLength();
                for (int j = 0; j < len; ++j) {
                    flag[po - j] = true;
                }
            }
            for (int k = 0; k < updateFlagLen; ++k) {
                byte des = 0;
                int tmp = 1;
                for (int m = 0; m < 8; ++m) {
                    if (!flag[8 * (updateFlagLen - k - 1) + m]) continue;
                    tmp = 1;
                    tmp = (byte)(tmp << m);
                    des = (byte)(des | tmp);
                }
                updateFlag[k] = des;
            }
            Logc.e("----------------------bb>" + Arrays.toString(flag));
            String result = StringUtil.byteArrayToHexString(updateFlag);
            System.out.println("----------------------uu>" + result);
            return result;
        }
        return null;
    }

    private int calcIndex(int updateFlagLen, int index) {
        int value = index / 8;
        int remain = index % 8;
        int xx = value + (remain == 0 ? 0 : 1);
        int po = 8 * (updateFlagLen - xx) + (remain == 0 ? 8 : remain);
        if (po <= updateFlagLen * 8) {
            return po - 1;
        }
        return -1;
    }
}

