/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.encode;

import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.encode.AbstractEncoder;
import com.het.xml.protocol.coder.encode.crc.CrcCalculateStrategy;
import com.het.xml.protocol.coder.utils.Crc16Utils;
import com.het.xml.protocol.utils.Logc;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Map;

public class FirstLayerProtocolEncoder
extends AbstractEncoder {
    private CrcCalculateStrategy crcCalculate;

    public void setCrcCalculate(CrcCalculateStrategy crcCalculate) {
        this.crcCalculate = crcCalculate;
    }

    @Override
    public byte[] encode(Object data) throws Exception {
        String key;
        ProtocolDefinition protocolDefinition;
        Object mainVersion = null;
        Object minorVersion = null;
        Object packageStart = null;
        if (data instanceof Map) {
            Map dto = (Map)data;
            mainVersion = dto.get("mainVersion");
            minorVersion = dto.get("minorVersion");
            packageStart = dto.get("packageStart");
        }
        if ((protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key = mainVersion + "-" + minorVersion + "-" + packageStart + "-E")) == null) {
            Logc.e("can't find the protocol configuration[protocolId:{}]" + key);
            throw new Exception("can't find the protocol configuration[protocolId:" + key + "]");
        }
        byte[] tempData = this.encode(protocolDefinition, data);
        if (protocolDefinition.isCrc()) {
            ByteArrayOutputStream byteArr = new ByteArrayOutputStream(tempData.length + 2);
            DataOutputStream out = new DataOutputStream(byteArr);
            out.write(tempData);
            int crc = Crc16Utils.computeChecksum(tempData, tempData.length);
            out.writeShort(crc);
            return byteArr.toByteArray();
        }
        return tempData;
    }
}

