/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.encode;

import com.het.xml.protocol.coder.DataType;
import com.het.xml.protocol.coder.DataTypeDefinition;
import com.het.xml.protocol.coder.bean.BaseDefinition;
import com.het.xml.protocol.coder.bean.BitDefinition;
import com.het.xml.protocol.coder.bean.ByteDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.encode.inter.Encoder;
import com.het.xml.protocol.coder.exception.EncodeException;
import com.het.xml.protocol.coder.exception.IllegalAttributeValue;
import com.het.xml.protocol.coder.parse.ProtocolFileLoadManager;
import com.het.xml.protocol.coder.utils.BeanUtils;
import com.het.xml.protocol.coder.utils.BinaryConvertUtils;
import com.het.xml.protocol.coder.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractEncoder
implements Encoder {
    private static final Map<String, Class> pramamterTypeMap = new HashMap<String, Class>();
    private static final Map<String, DataType> dataTypeMap = new HashMap<String, DataType>();
    protected ProtocolFileLoadManager protocolXmlManager;

    public void setProtocolXmlManager(ProtocolFileLoadManager protocolXmlManager) {
        this.protocolXmlManager = protocolXmlManager;
    }

    @Override
    public abstract byte[] encode(Object var1) throws Exception;

    public byte[] encode(ProtocolDefinition protocolDefinition, Object data) throws Exception {
        if (data == null || protocolDefinition == null) {
            throw new IllegalArgumentException("argument can't be null,please check...");
        }
        if (protocolDefinition.getClassName() == null || "".equals(protocolDefinition.getClassName())) {
            protocolDefinition.setClassName("java.util.HashMap");
        }
        this.check(protocolDefinition);
        ByteArrayOutputStream byteArr = new ByteArrayOutputStream(50);
        DataOutputStream outputStream = new DataOutputStream(byteArr);
        Object value = null;
        List<ByteDefinition> rule = protocolDefinition.getByteDefList();
        for (ByteDefinition element : rule) {
            if (element.getBitDefList() != null) {
                String propertyValue = "";
                int val = 0;
                int byteValue = 0;
                for (BitDefinition bit : element.getBitDefList()) {
                    if (bit.isIgnore()) continue;
                    propertyValue = this.getValue(data, bit.getProperty()).toString();
                    val = Integer.parseInt(propertyValue);
                    byteValue += this.writeBitByDefiniton(bit, val);
                }
                outputStream.writeByte(byteValue);
                continue;
            }
            DataType dataType = DataTypeDefinition.getDataType(element.getJavaType());
            if (dataType == null) {
                throw new IllegalAttributeValue("[protocolID:" + protocolDefinition.getId() + " property:" + element.getProperty() + "]-can't support \"" + element.getJavaType() + "\" data type,please check the \"JavaType\" value");
            }
            try {
                this.writeByteByDefinition(element, outputStream, dataType, data);
            }
            catch (Exception e) {
                throw new EncodeException("[property:" + element.getProperty() + "]-" + e.getMessage());
            }
        }
        return byteArr.toByteArray();
    }

    private void writeByteByDefinition(ByteDefinition byteDefinition, DataOutputStream outputStream, DataType dataType, Object instance) throws Exception {
        block86: {
            DataType realDataType;
            String propertyValue;
            Object value;
            block85: {
                value = null;
                if (!StringUtil.isEmpty(byteDefinition.getRefValue())) {
                    String val;
                    String[] tempArr;
                    Integer length = 0;
                    if (byteDefinition.getRefValue().matches("^\\w+[+|-]{1}\\d+$")) {
                        if (byteDefinition.getRefValue().contains("+")) {
                            tempArr = byteDefinition.getRefValue().split("\\+");
                            val = this.getValue(instance, tempArr[0].trim()).toString();
                            length = Integer.valueOf(val) + Integer.valueOf(tempArr[1]);
                        } else if (byteDefinition.getRefValue().contains("-")) {
                            tempArr = byteDefinition.getRefValue().split("-");
                            val = this.getValue(instance, tempArr[0].trim()).toString();
                            length = Integer.valueOf(val) - Integer.valueOf(tempArr[1]);
                        }
                    } else if (byteDefinition.getRefValue().matches("^\\d+$[+|-]{1}\\w+$")) {
                        if (byteDefinition.getRefValue().contains("+")) {
                            tempArr = byteDefinition.getRefValue().split("\\+");
                            val = this.getValue(instance, tempArr[1].trim()).toString();
                            length = Integer.valueOf(val) + Integer.valueOf(tempArr[0]);
                        } else if (byteDefinition.getRefValue().contains("-")) {
                            tempArr = byteDefinition.getRefValue().split("-");
                            val = this.getValue(instance, tempArr[1].trim()).toString();
                            length = Integer.valueOf(val) - Integer.valueOf(tempArr[0]);
                        }
                    } else {
                        String val2 = this.getValue(instance, byteDefinition.getRefValue()).toString();
                        if (val2.matches("\\d+\\.\\d+$")) {
                            val2 = val2.replaceAll("\\.\\d+$", "");
                        }
                        length = Integer.valueOf(val2);
                    }
                    byteDefinition.setLength(length);
                }
                if (StringUtil.isEmpty(byteDefinition.getJavaType())) {
                    throw new IllegalAttributeValue("the \"JavaType\" value can't be null");
                }
                if (dataType.getSize() == 0 && byteDefinition.getLength() == null) {
                    throw new IllegalAttributeValue("if the \"javaType\" value is not primitive data type, \"length\" value can't be null or zero");
                }
                propertyValue = null;
                if (dataType != DataType.BYTE_ARRAY && !byteDefinition.isIgnore()) {
                    propertyValue = this.getValue(instance, byteDefinition.getProperty()).toString();
                }
                if ((realDataType = this.getRealDataType(byteDefinition, dataType)) != null) break block85;
                switch (dataType) {
                    case INTEGER: 
                    case LONG: {
                        byte[] bytes;
                        Integer mulriple = byteDefinition.getMulriple();
                        if (!byteDefinition.isIgnore()) {
                            if (mulriple != null) {
                                Object tmpValue;
                                Double dValue = Double.parseDouble(propertyValue);
                                if (mulriple == 0) {
                                    mulriple = 1;
                                }
                                dValue = dValue * (double)mulriple.intValue();
                                long val = dValue.longValue();
                                if (value == null && byteDefinition != null) {
                                    value = byteDefinition.getValue();
                                }
                                if ((tmpValue = StringUtil.caclSigned(value, byteDefinition)) != null) {
                                    val = (Long)tmpValue;
                                }
                                bytes = BinaryConvertUtils.longToByteArray(val, byteDefinition.getLength());
                                outputStream.write(bytes);
                            } else {
                                Object tmpValue;
                                if (propertyValue.matches("\\d+\\.\\d+$")) {
                                    propertyValue = propertyValue.replaceAll("\\.\\d+$", "");
                                }
                                long val = Long.parseLong(propertyValue);
                                if (value == null && byteDefinition != null) {
                                    value = byteDefinition.getValue();
                                }
                                if ((tmpValue = StringUtil.caclSigned(value, byteDefinition)) != null) {
                                    val = (Long)tmpValue;
                                }
                                bytes = BinaryConvertUtils.longToByteArray(val, byteDefinition.getLength());
                                outputStream.write(bytes);
                            }
                        } else {
                            outputStream.write(new byte[byteDefinition.getLength().intValue()]);
                        }
                        break block86;
                    }
                    case STRING: {
                        byte[] temp;
                        byte[] bytes;
                        if (!byteDefinition.isIgnore()) {
                            temp = propertyValue.getBytes("UTF-8");
                            bytes = new byte[byteDefinition.getLength().intValue()];
                            int len = bytes.length;
                            if (temp != null && temp.length <= bytes.length) {
                                len = temp.length;
                            }
                            System.arraycopy(temp, 0, bytes, 0, len);
                            outputStream.write(bytes);
                        } else {
                            outputStream.write(new byte[byteDefinition.getLength().intValue()]);
                        }
                        break block86;
                    }
                    case HEX_STRING: {
                        byte[] temp;
                        byte[] bytes;
                        if (!byteDefinition.isIgnore()) {
                            temp = StringUtil.hexStringToByteArray(propertyValue);
                            bytes = new byte[byteDefinition.getLength().intValue()];
                            int len = bytes.length;
                            if (temp != null && temp.length <= bytes.length) {
                                len = temp.length;
                            }
                            System.arraycopy(temp, 0, bytes, 0, len);
                            outputStream.write(bytes);
                        } else {
                            outputStream.write(new byte[byteDefinition.getLength().intValue()]);
                        }
                        break block86;
                    }
                    case BYTE_ARRAY: {
                        if (!byteDefinition.isIgnore()) {
                            Object data = this.getValue(instance, byteDefinition.getProperty());
                            if (data != null) {
                                outputStream.write((byte[])data);
                            }
                        } else {
                            outputStream.write(new byte[byteDefinition.getLength().intValue()]);
                        }
                        break block86;
                    }
                    default: {
                        throw new EncodeException("does't support the \"JavaType\" " + byteDefinition.getJavaType());
                    }
                }
            }
            if (byteDefinition.getLength() != null && dataType.getSize() < byteDefinition.getLength()) {
                throw new IllegalAttributeValue("the \"length\" value does't match \"javaType\" value");
            }
            switch (realDataType) {
                case CHAR: {
                    if (!byteDefinition.isIgnore()) {
                        Object tmpValue;
                        char charValue = propertyValue.toCharArray()[0];
                        if (value == null && byteDefinition != null) {
                            value = byteDefinition.getValue();
                        }
                        if ((tmpValue = StringUtil.caclSigned(value, byteDefinition)) != null) {
                            charValue = ((Character)tmpValue).charValue();
                        }
                        outputStream.writeChar(charValue);
                        break;
                    }
                    outputStream.writeChar(0);
                    break;
                }
                case BYTE: {
                    Double dValue;
                    if (!byteDefinition.isIgnore()) {
                        Object tmpValue;
                        dValue = Double.parseDouble(propertyValue);
                        byte bValue = dValue.byteValue();
                        if (value == null && byteDefinition != null) {
                            value = byteDefinition.getValue();
                        }
                        if ((tmpValue = StringUtil.caclSigned(value, byteDefinition)) != null) {
                            bValue = (Byte)tmpValue;
                        }
                        outputStream.writeByte(bValue);
                        break;
                    }
                    outputStream.writeByte(0);
                    break;
                }
                case SHORT: {
                    Double dValue;
                    Integer mulriple;
                    if (!byteDefinition.isIgnore()) {
                        Object tmpValue;
                        mulriple = byteDefinition.getMulriple();
                        if (mulriple != null) {
                            Object tmpValue2;
                            dValue = Double.parseDouble(propertyValue);
                            if (mulriple == 0) {
                                mulriple = 1;
                            }
                            dValue = dValue * (double)mulriple.intValue();
                            short sValue = dValue.shortValue();
                            if (value == null && byteDefinition != null) {
                                value = byteDefinition.getValue();
                            }
                            if ((tmpValue2 = StringUtil.caclSigned(value, byteDefinition)) != null) {
                                sValue = (Short)tmpValue2;
                            }
                            outputStream.writeShort(sValue);
                            break;
                        }
                        dValue = Double.parseDouble(propertyValue);
                        long val = dValue.longValue();
                        if (value == null && byteDefinition != null) {
                            value = byteDefinition.getValue();
                        }
                        if ((tmpValue = StringUtil.caclSigned(value, byteDefinition)) != null) {
                            val = (Long)tmpValue;
                        }
                        byte[] bytes = BinaryConvertUtils.longToByteArray(val, byteDefinition.getLength());
                        outputStream.write(bytes);
                        break;
                    }
                    outputStream.writeShort(0);
                    break;
                }
                case INTEGER: {
                    Double dValue;
                    Integer mulriple;
                    if (!byteDefinition.isIgnore()) {
                        Object tmpValue;
                        mulriple = byteDefinition.getMulriple();
                        if (mulriple != null) {
                            Object tmpValue3;
                            dValue = Double.parseDouble(propertyValue);
                            if (mulriple == 0) {
                                mulriple = 1;
                            }
                            dValue = dValue * (double)mulriple.intValue();
                            long val = dValue.longValue();
                            if (value == null && byteDefinition != null) {
                                value = byteDefinition.getValue();
                            }
                            if ((tmpValue3 = StringUtil.caclSigned(value, byteDefinition)) != null) {
                                val = (Long)tmpValue3;
                            }
                            byte[] bytes = BinaryConvertUtils.longToByteArray(val, byteDefinition.getLength());
                            outputStream.write(bytes);
                            break;
                        }
                        dValue = Double.parseDouble(propertyValue);
                        long val = dValue.longValue();
                        if (value == null && byteDefinition != null) {
                            value = byteDefinition.getValue();
                        }
                        if ((tmpValue = StringUtil.caclSigned(value, byteDefinition)) != null) {
                            val = (Long)tmpValue;
                        }
                        byte[] bytes = BinaryConvertUtils.longToByteArray(val, byteDefinition.getLength());
                        outputStream.write(bytes);
                        break;
                    }
                    outputStream.writeInt(0);
                    break;
                }
                case LONG: {
                    Integer mulriple;
                    if (!byteDefinition.isIgnore()) {
                        Object tmpValue;
                        mulriple = byteDefinition.getMulriple();
                        if (mulriple != null) {
                            Object tmpValue4;
                            boolean isInterger = StringUtil.isInteger(propertyValue);
                            Double dValue = Double.parseDouble(propertyValue);
                            if (mulriple == 0) {
                                mulriple = 1;
                            }
                            dValue = dValue * (double)mulriple.intValue();
                            long lvalue = dValue.longValue();
                            if (value == null && byteDefinition != null) {
                                value = byteDefinition.getValue();
                            }
                            if ((tmpValue4 = StringUtil.caclSigned(value, byteDefinition)) != null) {
                                lvalue = (Long)tmpValue4;
                            }
                            if (isInterger) {
                                outputStream.writeLong(lvalue);
                                break;
                            }
                            outputStream.writeDouble(dValue);
                            break;
                        }
                        boolean isInterger = StringUtil.isInteger(propertyValue);
                        Double dValue = Double.parseDouble(propertyValue);
                        long lvalue = dValue.longValue();
                        if (value == null && byteDefinition != null) {
                            value = byteDefinition.getValue();
                        }
                        if ((tmpValue = StringUtil.caclSigned(value, byteDefinition)) != null) {
                            lvalue = (Long)tmpValue;
                        }
                        if (isInterger) {
                            outputStream.writeLong(lvalue);
                            break;
                        }
                        outputStream.writeDouble(dValue);
                        break;
                    }
                    outputStream.writeLong(0L);
                    break;
                }
                case FLOAT: {
                    Double dValue;
                    if (!byteDefinition.isIgnore()) {
                        Object tmpValue;
                        dValue = Double.parseDouble(propertyValue);
                        float fValue = dValue.floatValue();
                        if (value == null && byteDefinition != null) {
                            value = byteDefinition.getValue();
                        }
                        if ((tmpValue = StringUtil.caclSigned(value, byteDefinition)) != null) {
                            fValue = ((Float)tmpValue).floatValue();
                        }
                        outputStream.writeFloat(fValue);
                        break;
                    }
                    outputStream.writeFloat(0.0f);
                    break;
                }
                case DOUBLE: {
                    Double dValue;
                    if (!byteDefinition.isIgnore()) {
                        Object tmpValue;
                        dValue = Double.parseDouble(propertyValue);
                        double dVa = dValue;
                        if (value == null && byteDefinition != null) {
                            value = byteDefinition.getValue();
                        }
                        if ((tmpValue = StringUtil.caclSigned(value, byteDefinition)) != null) {
                            dVa = (Double)tmpValue;
                        }
                        outputStream.writeDouble(dVa);
                        break;
                    }
                    outputStream.writeDouble(0.0);
                    break;
                }
                default: {
                    throw new EncodeException("does't support the \"JavaType\" " + byteDefinition.getJavaType());
                }
            }
        }
    }

    private int writeBitByDefiniton(BitDefinition bitDefinition, int val) throws Exception {
        int value = 0;
        Integer length = bitDefinition.getLength();
        if (length == null || length <= 0) {
            throw new IllegalAttributeValue("[property:" + bitDefinition.getProperty() + "]-label \"bitDef\" does't set \"length\" value");
        }
        if (bitDefinition.getShift() == null) {
            throw new IllegalAttributeValue("[property:" + bitDefinition.getProperty() + "]-label \"bitDef\" does't set \"shift\" value");
        }
        value = val << bitDefinition.getShift() & 0xFF;
        return value;
    }

    private Class getParameterType(BaseDefinition definition, DataType dataType) {
        Class parameterType;
        if (definition.getLength() != null && definition.getLength() > 0) {
            String key = definition.getLength() + "-" + dataType.getCategory();
            parameterType = pramamterTypeMap.get(key);
        } else {
            String key = dataType.getSize() + "-" + dataType.getCategory();
            parameterType = pramamterTypeMap.get(key);
        }
        return parameterType;
    }

    private DataType getRealDataType(BaseDefinition definition, DataType dataType) {
        DataType type;
        if (definition.getLength() != null) {
            String key = definition.getLength() + "-" + dataType.getCategory();
            type = dataTypeMap.get(key);
        } else {
            type = dataType;
        }
        return type;
    }

    private void check(ProtocolDefinition protocolDefinition) throws EncodeException {
        if (protocolDefinition.getId() == null || "".equals(protocolDefinition.getId())) {
            throw new EncodeException("[protocolID:" + protocolDefinition.getId() + "]-the value of label \"id\" can't be null");
        }
        if (protocolDefinition.getClassName() == null || "".equals(protocolDefinition.getClassName())) {
            throw new EncodeException("[protocolID:" + protocolDefinition.getId() + "]-the value of label \"className\" can't be null");
        }
        if (protocolDefinition.getByteDefList() == null || protocolDefinition.getByteDefList().size() == 0) {
            throw new EncodeException("[protocolID:" + protocolDefinition.getId() + "]-the value of label \"definitions\" can't be null");
        }
    }

    private Object getValue(Object obj, String property) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object val = null;
        if (obj instanceof Map) {
            Map map = (Map)obj;
            Object tmp = map.get(property);
            if (property != null && property.equalsIgnoreCase("updateFlag") && tmp == null) {
                tmp = "";
            }
            val = tmp;
        } else {
            String tmp = BeanUtils.getProperty(obj, property);
            val = tmp;
        }
        val = val == null ? Integer.valueOf(0) : val;
        return val;
    }

    static {
        pramamterTypeMap.put("1-char", Integer.class);
        pramamterTypeMap.put("1-number", Integer.class);
        pramamterTypeMap.put("2-number", Integer.class);
        pramamterTypeMap.put("4-number", Integer.class);
        pramamterTypeMap.put("4-float", Float.class);
        pramamterTypeMap.put("8-number", Long.class);
        pramamterTypeMap.put("8-float", Double.class);
        dataTypeMap.put("1-char", DataType.CHAR);
        dataTypeMap.put("1-number", DataType.BYTE);
        dataTypeMap.put("2-number", DataType.SHORT);
        dataTypeMap.put("4-number", DataType.INTEGER);
        dataTypeMap.put("4-float", DataType.FLOAT);
        dataTypeMap.put("8-number", DataType.LONG);
        dataTypeMap.put("8-float", DataType.DOUBLE);
    }
}

