/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.decode;

import android.text.TextUtils;
import com.het.xml.protocol.coder.bean.BaseDefinition;
import com.het.xml.protocol.coder.bean.ByteDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.decode.AbstractDecoder;
import com.het.xml.protocol.coder.exception.DecodeException;
import com.het.xml.protocol.coder.utils.BinaryConvertUtils;
import com.het.xml.protocol.coder.utils.StringUtil;
import com.het.xml.protocol.utils.Logc;
import com.het.xml.protocol.utils.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecondLayerProtocolDecoder
extends AbstractDecoder {
    private HashMap<String, BaseDefinition> mapper = null;

    @Override
    public <T> T decode(Object data) throws Exception {
        T result = null;
        if (data instanceof Map) {
            StringBuilder sb;
            Map map = (Map)data;
            Object dataVersion = map.get("dataVersion");
            Object deviceType = map.get("deviceType");
            Object deviceSubType = map.get("deviceSubType");
            short cmd = (Short)map.get("command");
            Object productId = map.get("productId");
            String command = StringUtil.byteArrayToHexString(BinaryConvertUtils.longToByteArray(cmd, 2));
            StringBuilder keyBuilder = new StringBuilder();
            keyBuilder.append(dataVersion).append("-").append(deviceType).append("-").append(deviceSubType).append("-").append(command);
            String key = keyBuilder.toString();
            byte[] deviceData = (byte[])map.get("data");
            boolean empty = map.get("empty") == null ? false : (Boolean)map.get("empty");
            ProtocolDefinition protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
            if (protocolDefinition == null) {
                key = dataVersion + "-" + command;
                protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
            }
            if (protocolDefinition == null) {
                sb = new StringBuilder();
                sb.append("2").append("-").append(deviceType).append("-").append(deviceSubType).append("-").append(command);
                key = sb.toString();
                protocolDefinition = this.protocolXmlManager.getProtocolDefinition(sb.toString());
            }
            if (protocolDefinition == null) {
                sb = new StringBuilder();
                sb.append(productId).append("-").append(command);
                key = sb.toString();
                protocolDefinition = this.protocolXmlManager.getProtocolDefinition(sb.toString());
            }
            if (protocolDefinition == null) {
                Logc.e("<PROTOCOL_ID:{}>can't find the protocol configuration" + key);
                throw new DecodeException("<PROTOCOL_ID:" + key + ">can't find the protocol configuration");
            }
            int bodyLen = this.calcBodyLength(protocolDefinition);
            if (empty) {
                deviceData = new byte[bodyLen];
            }
            if (deviceData == null) {
                Logc.e("deviceData is null. PROTOCOL_ID:" + key);
                throw new DecodeException("deviceData is null. PROTOCOL_ID:" + key);
            }
            try {
                this.mapper = this.protocolXmlManager.get0104Mapper(key);
            }
            catch (Exception e) {
                Logc.e("<PROTOCOL_ID=" + key + ">EXCEPTION=" + e);
            }
            try {
                result = this.decode(protocolDefinition, deviceData);
            }
            catch (Exception e) {
                Logc.e("<PROTOCOL_ID:" + key + ">EXCEPTION" + e);
                throw new DecodeException("<PROTOCOL_ID:" + protocolDefinition.getId() + ">" + e.getMessage());
            }
        }
        return result;
    }

    private int calcBodyLength(ProtocolDefinition protocolDefinition) {
        List<ByteDefinition> byteList = protocolDefinition.getByteDefList();
        int len = 0;
        for (ByteDefinition item : byteList) {
            len += item.getLength() == null ? 1 : item.getLength();
        }
        Logc.i("bodyLen = " + len);
        return len;
    }

    public void updataFlagFilter(HashMap dto) {
        if (this.mapper != null) {
            String UPDATEFLAG_KAY = "updateFlag";
            if (dto == null || !dto.containsKey("updateFlag")) {
                return;
            }
            String updataFlag = (String)dto.get("updateFlag");
            if (TextUtils.isEmpty((CharSequence)updataFlag)) {
                return;
            }
            List<String> list = StrUtil.getStrList(updataFlag, 2);
            BaseDefinition vv = this.mapper.get("updateFlag");
            if (vv != null) {
                int updateFlagLen = vv.getLength();
                ArrayList<BaseDefinition> keyValye = new ArrayList<BaseDefinition>(this.mapper.values());
                if (updateFlagLen > 0 && keyValye != null && keyValye.size() > 0) {
                    for (int i = 0; i < keyValye.size(); ++i) {
                        BaseDefinition bd = (BaseDefinition)keyValye.get(i);
                        String key = bd.getProperty();
                        if (bd == null) continue;
                        int index = bd.getIndex();
                        int pos1 = index / 8;
                        int pos2 = index % 8;
                        int value = 1 << pos2;
                        String destStr = list.get(pos1);
                        Integer destInt = Integer.valueOf(destStr, 16);
                        int destValue = destInt;
                        if ((destValue & value) == value) continue;
                        dto.remove(key);
                    }
                }
            }
        }
    }
}

