/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.decode;

import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.decode.AbstractDecoder;
import com.het.xml.protocol.utils.Logc;

public class FirstLayerProtocolDecoder
extends AbstractDecoder {
    @Override
    public <T> T decode(Object data) throws Exception {
        byte[] origData = (byte[])data;
        byte version = 0;
        String header = "";
        int packageStart = origData[0] & 0xFF;
        if (packageStart == 242) {
            version = origData[1];
            header = "F2";
        } else if (packageStart == 90) {
            version = origData[2];
            header = "5A";
        }
        Integer mainVersion = version >>> 6 & 3;
        Integer minorVersion = version & 0x3F;
        String key = mainVersion + "-" + minorVersion + "-" + header + "-D";
        ProtocolDefinition protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        if (protocolDefinition == null) {
            Logc.e("can't find the protocol configuration[protocolId:{}]" + key);
            throw new Exception("can't find the protocol configuration[protocolId:" + key + "]");
        }
        protocolDefinition.setClassName(null);
        return this.decode(protocolDefinition, origData);
    }
}

