package com.het.xml.protocol;

import com.het.xml.protocol.coder.utils.StringUtil;

public class Main {
    /**
     * 求负数的补码的方法。 注意： 负数的补码是在其原码的基础上，符号位不变，其余位取反，然后加1
     *
     * @param a
     * @author lhever 2017年4月4日 下午8:42:47
     * @since v1.0
     */
    public static long encodeFanMaInt(int a) {
        long value = 0;
        for (int i = 0; i < 32; i++) {
            // 0x80000000 是一个首位为1，其余位数为0的整数
            int t = (a & 0x80000000 >>> i) >>> (31 - i);
            System.out.print(t);
            int tmp = t << i;
            value |= tmp;
        }
        System.out.println(">>" + value);
        return value;
    }

    public static long encodeFanMaShort(int a) {
        long value = 0;
        for (int i = 0; i < 16; i++) {
            // 0x80000000 是一个首位为1，其余位数为0的整数
            int t = (a & 0x8000 >>> i) >>> (15 - i);
            System.out.print(t);
            int tmp = t << i;
            value |= tmp;
        }
        System.out.println(">>" + value);
        return value;
    }

    public static long encodeFanMaByte(int a) {
        long value = 0;
        for (int i = 0; i < 8; i++) {
            // 0x80000000 是一个首位为1，其余位数为0的整数
            int t = (a & 0x80 >>> i) >>> (7 - i);
            System.out.print(t);
            int tmp = t << (7 - i);
            value |= tmp;
        }
        System.out.println(">>" + value);
        return value;
    }


    public static long binaryToDecimal(long n) {
        byte value = 0;
        for (int i = 7; i >= 0; i--) {
            long t = n >>> i & 1;
            System.out.print(t);
            long tmp = t << i;
            value |= tmp;
        }
//        System.out.println(">>" + value);
        return value;
    }

    public static long binaryToDecimal16(long n) {
        long value = 0;
        for (int i = 15; i >= 0; i--) {
            long t = n >>> i & 1;
            System.out.print(t);
            long tmp = t << i;
            value |= tmp;
        }
//        System.out.println(">>" + value);
        return value;
    }

    public static long binaryToDecimal32(long n) {
        long value = 0;
        for (int i = 15; i >= 0; i--) {
            long t = n >>> i & 1;
            System.out.print(t);
            long tmp = t << i;
            value |= tmp;
        }
//        System.out.println(">>" + value);
        return value;
    }

    public static long binaryToDecimal64(long n) {
        long value = 0;
        for (int i = 15; i >= 0; i--) {
            long t = n >>> i & 1;
            System.out.print(t);
            long tmp = t << i;
            value |= tmp;
        }
//        System.out.println(">>" + value);
        return value;
    }

    public static void main(String[] args) {
        int value = -8;
        long aa = StringUtil.binaryToDecimal8(value);
        System.out.println(">补码>" + aa);
        long bb = ~(aa - 1);
//        bb += 128;
        byte cc = (byte) StringUtil.binaryToDecimal8(bb);
        System.out.println(">原码>" + cc);

        byte cByte = StringUtil.binaryToDecimal8(aa);
        System.out.println(">原码>" + cByte);

        int a = 0x80;
        System.out.println("a:"+a);
//        String filePath = "E:\\Het\\xml";
//        ProtocolManager.getInstance().loadProtocolXmlPath(filePath, null);
    }
}
