package com.proximities.sdk.json.model.appointments;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.Keep;

@Keep
public class ContentTemplate implements Parcelable {

    private int id;
    private String identifier;
    private String type;
    private String name;
    private String title;
    private String contentText;
    private String created;
    private String updated;
    private int status;
    private int archive;

    protected ContentTemplate(Parcel in) {
        id = in.readInt();
        identifier = in.readString();
        type = in.readString();
        name = in.readString();
        title = in.readString();
        contentText = in.readString();
        created = in.readString();
        updated = in.readString();
        status = in.readInt();
        archive = in.readInt();
    }

    public static final Creator<ContentTemplate> CREATOR = new Creator<ContentTemplate>() {
        @Override
        public ContentTemplate createFromParcel(Parcel in) {
            return new ContentTemplate(in);
        }

        @Override
        public ContentTemplate[] newArray(int size) {
            return new ContentTemplate[size];
        }
    };

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContentText() {
        return contentText;
    }

    public void setContentText(String contentText) {
        this.contentText = contentText;
    }

    public String getCreated() {
        return created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getUpdated() {
        return updated;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getArchive() {
        return archive;
    }

    public void setArchive(int archive) {
        this.archive = archive;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(id);
        parcel.writeString(identifier);
        parcel.writeString(type);
        parcel.writeString(name);
        parcel.writeString(title);
        parcel.writeString(contentText);
        parcel.writeString(created);
        parcel.writeString(updated);
        parcel.writeInt(status);
        parcel.writeInt(archive);
    }
}
