package com.proximities.sdk.json.model.appointments;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.Keep;

@Keep
public class Appointment implements Parcelable {

    private int id;
    private String startDate;
    private String endDate;
    private String appointmentId;
    private String with;
    private String email;
    private String phone;
    private String informations;
    private String state;
    private String created;
    private String updated;
    private int status;
    private int archive;
    private IpsTriggerInfo ipsTriggerInfo;
    private ContentTemplate contentTemplate;

    protected Appointment(Parcel in) {
        id = in.readInt();
        startDate = in.readString();
        endDate = in.readString();
        appointmentId = in.readString();
        with = in.readString();
        email = in.readString();
        phone = in.readString();
        informations = in.readString();
        state = in.readString();
        created = in.readString();
        updated = in.readString();
        status = in.readInt();
        archive = in.readInt();
        ipsTriggerInfo = in.readParcelable(IpsTriggerInfo.class.getClassLoader());
        contentTemplate = in.readParcelable(ContentTemplate.class.getClassLoader());
    }

    public static final Creator<Appointment> CREATOR = new Creator<Appointment>() {
        @Override
        public Appointment createFromParcel(Parcel in) {
            return new Appointment(in);
        }

        @Override
        public Appointment[] newArray(int size) {
            return new Appointment[size];
        }
    };

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getAppointmentId() {
        return appointmentId;
    }

    public void setAppointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
    }

    public String getWith() {
        return with;
    }

    public void setWith(String with) {
        this.with = with;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getInformations() {
        return informations;
    }

    public void setInformations(String informations) {
        this.informations = informations;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCreated() {
        return created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getUpdated() {
        return updated;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getArchive() {
        return archive;
    }

    public void setArchive(int archive) {
        this.archive = archive;
    }

    public IpsTriggerInfo getIpsTriggerInfo() {
        return ipsTriggerInfo;
    }

    public void setIpsTriggerInfo(IpsTriggerInfo ipsTriggerInfo) {
        this.ipsTriggerInfo = ipsTriggerInfo;
    }

    public ContentTemplate getContentTemplate() {
        return contentTemplate;
    }

    public void setContentTemplate(ContentTemplate contentTemplate) {
        this.contentTemplate = contentTemplate;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(id);
        parcel.writeString(startDate);
        parcel.writeString(endDate);
        parcel.writeString(appointmentId);
        parcel.writeString(with);
        parcel.writeString(email);
        parcel.writeString(phone);
        parcel.writeString(informations);
        parcel.writeString(state);
        parcel.writeString(created);
        parcel.writeString(updated);
        parcel.writeInt(status);
        parcel.writeInt(archive);
        parcel.writeParcelable(ipsTriggerInfo, i);
        parcel.writeParcelable(contentTemplate, i);
    }
}
