package com.proximities.sdk.json.model.appointments;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.Keep;

import java.util.List;

@Keep
public class IpsTriggerInfo implements Parcelable {

    private int id;
    private String name;
    private String type;
    private String keywords;
    private IpsTriggerInfoProperties properties;
    private String icon;
    private int shortcut;
    private List<IpsTrigger> ipsTriggers;

    protected IpsTriggerInfo(Parcel in) {
        id = in.readInt();
        name = in.readString();
        type = in.readString();
        keywords = in.readString();
        properties = in.readParcelable(IpsTriggerInfoProperties.class.getClassLoader());
        icon = in.readString();
        shortcut = in.readInt();
        ipsTriggers = in.createTypedArrayList(IpsTrigger.CREATOR);
    }

    public static final Creator<IpsTriggerInfo> CREATOR = new Creator<IpsTriggerInfo>() {
        @Override
        public IpsTriggerInfo createFromParcel(Parcel in) {
            return new IpsTriggerInfo(in);
        }

        @Override
        public IpsTriggerInfo[] newArray(int size) {
            return new IpsTriggerInfo[size];
        }
    };

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public IpsTriggerInfoProperties getProperties() {
        return properties;
    }

    public void setProperties(IpsTriggerInfoProperties properties) {
        this.properties = properties;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public int getShortcut() {
        return shortcut;
    }

    public void setShortcut(int shortcut) {
        this.shortcut = shortcut;
    }

    public List<IpsTrigger> getIpsTriggers() {
        return ipsTriggers;
    }

    public void setIpsTriggers(List<IpsTrigger> ipsTriggers) {
        this.ipsTriggers = ipsTriggers;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {

        parcel.writeInt(id);
        parcel.writeString(name);
        parcel.writeString(type);
        parcel.writeString(keywords);
        parcel.writeParcelable(properties, i);
        parcel.writeString(icon);
        parcel.writeInt(shortcut);
        parcel.writeTypedList(ipsTriggers);
    }
}
