package com.proximities.sdk.fragment.templates;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.core.content.ContextCompat;
import android.util.Base64;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.Utils;
import com.proximities.sdk.bridge.OnUrlRequestListener;
import com.proximities.sdk.interfaces.LoyaltyInterface;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;

/**
 * Created by William Mouliné on 22/03/17.
 */

public class LoyaltyFragment extends Fragment implements LoyaltyInterface{

    private ImageView banner;
    private ImageView image;
    private LinearLayout textPart;
    private RelativeLayout mainLayout;
    private TextView title;
    private WebView content;
    private ProgressBar spinner;
    private LinearLayout resetLoyaltyLayout;
    private Button btnAcceptResetLoyalty;
    private Button btnRefuseResetLoyalty;

    private OnUrlRequestListener urlRequestListener;
    private Campaign campaign;
    private boolean isBannerLoaded = false;
    private boolean isImageLoaded = false;
    private boolean isWebViewLoaded = false;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if(context instanceof OnUrlRequestListener){
            urlRequestListener = (OnUrlRequestListener) context;
        }
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = getArguments();
        campaign = bundle.getParcelable(ProximitiesConstants.CAMPAIGN_EXTRA);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.prxsc_template_loyalty_fragment, container, false);
        mainLayout = (RelativeLayout) view.findViewById(R.id.main_layout);
        banner = (ImageView) view.findViewById(R.id.banner);
        image = (ImageView) view.findViewById(R.id.image);
        textPart = (LinearLayout) view.findViewById(R.id.text_part);
        spinner = (ProgressBar) view.findViewById(R.id.spinner);
        title = (TextView) view.findViewById(R.id.title);
        content = (WebView) view.findViewById(R.id.content);
        resetLoyaltyLayout = (LinearLayout) view.findViewById(R.id.loyalty_reset_layout);
        btnAcceptResetLoyalty = (Button) view.findViewById(R.id.btn_reset_accept);
        btnRefuseResetLoyalty = (Button) view.findViewById(R.id.btn_reset_refuse);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        displayImages();
        displayContent();
        displayLoyaltyReset();
    }

    @Override
    public void onRefreshLoyaltySuccess(Campaign campaign) {
        this.campaign = campaign;
        displayContent();
        resetLoyaltyLayout.setVisibility(View.GONE);
        spinner.setVisibility(View.GONE);
    }

    @Override
    public void onRefreshLoyaltyError() {
        spinner.setVisibility(View.GONE);
        Toast.makeText(getActivity(), getActivity().getString(R.string.prxsc_loyalty_confirm_refresh_error), Toast.LENGTH_LONG).show();
    }

    private void displayImages() {
        if (campaign.getBanner() != null && !campaign.getBanner().isEmpty()) {
            banner.setVisibility(View.VISIBLE);
            String url = BuildConfig.HOST + campaign.getBanner();
            Glide.with(getActivity()).load(url)
                    .asBitmap()
                    .into(new SimpleTarget<Bitmap>() {
                        @Override
                        public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                            banner.setImageBitmap(resource);
                            isBannerLoaded = true;
                            checkIfEveryThingIsLoaded();
                        }

                        @Override
                        public void onLoadFailed(Exception e, Drawable errorDrawable) {
                            isBannerLoaded = true;
                            checkIfEveryThingIsLoaded();
                            if(campaign.getBannerOffline()!= null && !campaign.getBannerOffline().isEmpty()) {
                                byte[] decodedString = Base64.decode(campaign.getBannerOffline(), Base64.DEFAULT);
                                banner.setImageBitmap(BitmapFactory.decodeByteArray(decodedString, 0, decodedString.length));
                            }
                            super.onLoadFailed(e, errorDrawable);
                        }
                    });
            banner.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
        } else {
            isBannerLoaded = true;
            banner.setVisibility(View.GONE);
        }
        if (campaign.getImage() != null && !campaign.getImage().isEmpty()) {
            image.setVisibility(View.VISIBLE);
            String url = BuildConfig.HOST + campaign.getImage();
            Glide.with(getActivity()).load(url)
                    .asBitmap()
                    .into(new SimpleTarget<Bitmap>() {
                        @Override
                        public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                            isImageLoaded = true;
                            checkIfEveryThingIsLoaded();
                            image.setImageBitmap(resource);
                        }

                        @Override
                        public void onLoadFailed(Exception e, Drawable errorDrawable) {
                            isImageLoaded = true;
                            checkIfEveryThingIsLoaded();
                            if(campaign.getImageOffline()!= null && !campaign.getImageOffline().isEmpty()) {
                                byte[] decodedString = Base64.decode(campaign.getImageOffline(), Base64.DEFAULT);
                                image.setImageBitmap(BitmapFactory.decodeByteArray(decodedString, 0, decodedString.length));
                            }
                            super.onLoadFailed(e, errorDrawable);
                        }
                    });
            image.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));

        } else {
            isImageLoaded = true;
            image.setVisibility(View.GONE);
        }
    }

    private void displayContent() {
        int textColor = ContextCompat.getColor(getActivity(), android.R.color.black);  // TODO define a default content font color
        if (campaign.getContentFontColor() != null && !campaign.getContentFontColor().isEmpty()) {
            textColor = Color.parseColor(campaign.getContentFontColor());
        }
        if (campaign.getTopbarTitle() != null && !campaign.getTopbarTitle().isEmpty()) {
            //title.setVisibility(View.VISIBLE);
            title.setText(campaign.getTopbarTitle());
            title.setTextColor(textColor);
        } else {
            title.setVisibility(View.GONE);
        }
        if (campaign.getContentText() != null && !campaign.getContentText().isEmpty()) {
            content.setVisibility(View.VISIBLE);
            content.setBackgroundColor(Color.TRANSPARENT);
            String myHtml = "<html><head>"
                    + "<style type=\"text/css\">body{color: " + campaign.getContentFontColor() + ";}"
                    + "</style>"
                    + "</head>"
                    + "<body>"
                    + campaign.getContentText()
                    + "</body></html>";
            content.loadDataWithBaseURL(null, myHtml, "text/html", "UTF-8", null);
            content.setWebViewClient(new WebViewClient() {
                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if(Patterns.WEB_URL.matcher(url).matches()) {
                        boolean isUrlHandled = false;
                        if(ProximitiesConfig.getInstance() != null){
                            if(ProximitiesConfig.getOnCampaignURLClickListener() != null) isUrlHandled = ProximitiesConfig.getOnCampaignURLClickListener().onCampaignURLCLick(url);
                        }
                        if(!isUrlHandled)
                            urlRequestListener.displayUrlView(url);
                    } else {
                        Intent callIntent = new Intent(Intent.ACTION_DIAL);
                        callIntent.setData(Uri.parse("tel:" + url));
                        startActivity(callIntent);
                    }
                    return true;
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    isWebViewLoaded = true;
                    checkIfEveryThingIsLoaded();
                    super.onPageFinished(view, url);
                }
            });
            // content.setText(Html.fromHtml(campaign.getContentText()));
            // content.setTextColor(textColor);
        } else {
            isWebViewLoaded = true;
            content.setVisibility(View.GONE);
        }
        if (campaign.getContentBackgroundColor() != null && !campaign.getContentBackgroundColor().isEmpty()) {
            textPart.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
            mainLayout.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
        }
    }

    private void displayLoyaltyReset(){
        if(campaign.getNbStamps() != 0 && campaign.getUserStamps() == campaign.getNbStamps()) {
            resetLoyaltyLayout.setVisibility(View.VISIBLE);
            btnAcceptResetLoyalty.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    LayoutInflater factory = LayoutInflater.from(getActivity());
                    final View dialogView = factory.inflate(R.layout.prxsc_refresh_loyalty_dialog, null);
                    final AlertDialog dialog = new AlertDialog.Builder(getActivity()).create();
                    dialog.setView(dialogView);

                    final TextView title = (TextView) dialogView.findViewById(R.id.title_dialog);
                    title.setText(getString(R.string.prxsc_loyalty_confirm_refresh_title));

                    final TextView content = (TextView) dialogView.findViewById(R.id.content_dialog);
                    content.setText(getString(R.string.prxsc_loyalty_confirm_refresh_content));

                    final Button buttonYes = (Button) dialogView.findViewById(R.id.choice_positive);
                    buttonYes.setText(getString((R.string.prxsc_agree)));
                    buttonYes.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            spinner.setVisibility(View.VISIBLE);
                            Utils.refreshLoyalty(LoyaltyFragment.this, campaign.getId());
                            dialog.dismiss();
                        }
                    });

                    final Button buttonCancel = (Button) dialogView.findViewById(R.id.choice_negative);
                    buttonCancel.setText(getString((R.string.prxsc_disagree)));
                    buttonCancel.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            dialog.dismiss();
                        }
                    });

                    dialog.show();

                }
            });

            btnRefuseResetLoyalty.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    resetLoyaltyLayout.setVisibility(View.GONE);
                }
            });
        }
    }

    private void checkIfEveryThingIsLoaded(){
        if(isWebViewLoaded && isImageLoaded && isBannerLoaded){
            spinner.setVisibility(View.GONE);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if(campaign != null && content != null){
            content.onResume();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if(campaign != null && content != null){
            content.onPause();
        }
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        if(campaign != null && content != null){
            content.destroy();
        }
    }
}
