package com.proximities.sdk.fragment.templates;

import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;

import com.proximities.sdk.R;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;

/**
 * Created by William Mouliné on 30/06/17.
 */

public class FullScreenImageFragment extends Fragment {

    private WebView webview;
    private ProgressBar spinner;
    private ImageView btnClose;
    private Campaign campaign;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = getArguments();
        campaign = bundle.getParcelable(ProximitiesConstants.CAMPAIGN_EXTRA);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.prxsc_template_fullscreen_image_fragment, container, false);
        spinner = (ProgressBar) v.findViewById(R.id.spinner_fullscreen_image);
        webview = (WebView) v.findViewById(R.id.webview_image);
        btnClose = (ImageView) v.findViewById(R.id.btn_close_campaign);
        return v;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        btnClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().onBackPressed();
            }
        });
        initWebViewDisplay();
    }

    private void initWebViewDisplay(){
        if(campaign.getTopbarFontColor() != null){
            int color = Color.parseColor(campaign.getTopbarFontColor());
            btnClose.setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.MULTIPLY));
//            spinner.getProgressDrawable().setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.MULTIPLY));
        }
        if(campaign.getWebviewUrl() != null){
            webview.setWebViewClient(new WebViewClient(){
                @Override
                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    spinner.setVisibility(View.GONE);
                }
            });
            webview.loadDataWithBaseURL(null, campaign.getContentText(), "text/html", "UTF-8", null);
        } else {
            spinner.setVisibility(View.GONE);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if(campaign != null && webview != null){
            webview.onResume();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if(campaign != null && webview != null){
            webview.onPause();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if(campaign != null && webview != null){
            webview.destroy();
        }
    }
}
