package com.proximities.sdk.activities;

import android.annotation.SuppressLint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import com.proximities.sdk.R;
import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.Utils;

/**
 * Created by william on 07/09/16.
 */
public class WebViewActivity extends AppCompatActivity {

    @SuppressLint("SetJavaScriptEnabled")
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.prxsc_webview_activity);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        final ProgressBar spinner = (ProgressBar) findViewById(R.id.spinner);
        WebView webView = (WebView) findViewById(R.id.webview);

        setSupportActionBar(toolbar);
        if(getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setHomeButtonEnabled(true);
        }
        if(toolbar != null){
            int toolbarColor = ContextCompat.getColor(this, R.color.prxsc_multi_campaign_toolbar);
            Drawable closeDrawable = ContextCompat.getDrawable(this, R.drawable.prxsc_ic_clear);
            closeDrawable.setColorFilter(new PorterDuffColorFilter(ContextCompat.getColor(this, (Utils.isColorDark(toolbarColor)) ? android.R.color.white : android.R.color.black), PorterDuff.Mode.MULTIPLY));
            toolbar.setNavigationIcon(closeDrawable);
            toolbar.setBackgroundColor(ContextCompat.getColor(this, R.color.prxsc_multi_campaign_toolbar));
        }
        String url = "";
        if(getIntent() != null) url = getIntent().getStringExtra(ProximitiesConstants.URL_EXTRA);
        if(spinner != null) spinner.getIndeterminateDrawable().setColorFilter(ContextCompat.getColor(this, R.color.prxsc_multi_campaign_toolbar), android.graphics.PorterDuff.Mode.MULTIPLY);
        if(webView != null) {
            WebSettings settings = webView.getSettings();
            settings.setJavaScriptEnabled(true);
            webView.setWebViewClient(new WebViewClient(){
                @Override
                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    if(spinner != null) spinner.setVisibility(View.GONE);
                }
            });
            if(!url.isEmpty()) webView.loadUrl(url);
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch(item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }
}
