package com.proximities.sdk.activities;

import android.Manifest;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.appcompat.app.AppCompatActivity;

import com.proximities.sdk.ProximitiesConfig;

/**
 * Created by william on 14/10/15.
 */
public class PermissionDialogActivity extends AppCompatActivity{

    private static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION = 5;
    private static final int MY_PERMISSIONS_REQUEST_ACCESS_BACKGROUND_LOCATION = 6;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        }
        if(ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED){
            ActivityCompat.requestPermissions(PermissionDialogActivity.this, new String[]{Manifest.permission.ACCESS_FINE_LOCATION},
                    MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION);
        } else if(android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q &&
                ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_BACKGROUND_LOCATION) != PackageManager.PERMISSION_GRANTED){
            ActivityCompat.requestPermissions(PermissionDialogActivity.this, new String[]{Manifest.permission.ACCESS_BACKGROUND_LOCATION},
                    MY_PERMISSIONS_REQUEST_ACCESS_BACKGROUND_LOCATION);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION: {
                if(android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q &&
                        ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_BACKGROUND_LOCATION) != PackageManager.PERMISSION_GRANTED){
                    ActivityCompat.requestPermissions(PermissionDialogActivity.this, new String[]{Manifest.permission.ACCESS_BACKGROUND_LOCATION},
                            MY_PERMISSIONS_REQUEST_ACCESS_BACKGROUND_LOCATION);
                } else {
                    if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                        finish();
                        if(ProximitiesConfig.getOnAccessLocationListener() != null){
                            ProximitiesConfig.getOnAccessLocationListener().onAccessLocationGranted();
                        }
                    } else {
                        finish();
                        if(ProximitiesConfig.getOnAccessLocationListener() != null){
                            ProximitiesConfig.getOnAccessLocationListener().onAccessLocationDenied();
                        }
                    }
                }
                break;
            }
            case MY_PERMISSIONS_REQUEST_ACCESS_BACKGROUND_LOCATION:
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    finish();
                    if(ProximitiesConfig.getOnAccessLocationListener() != null){
                        ProximitiesConfig.getOnAccessLocationListener().onAccessLocationGranted();
                    }
                } else {
                    finish();
                    if(ProximitiesConfig.getOnAccessLocationListener() != null){
                        ProximitiesConfig.getOnAccessLocationListener().onAccessLocationDenied();
                    }
                }
        }
    }

}
