package com.proximities.sdk;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.HandlerThread;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import androidx.work.impl.utils.futures.SettableFuture;

import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.common.util.concurrent.ListenableFuture;

import java.lang.ref.WeakReference;

public class ProximitiesWorker extends ListenableWorker {

    private SettableFuture<Result> mFuture;

    public ProximitiesWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @SuppressLint("RestrictedApi")
    @NonNull
    @Override
    public ListenableFuture<Result> startWork() {
        mFuture = SettableFuture.create();
        if(ContextCompat.checkSelfPermission(getApplicationContext(), Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED){
            mFuture.set(Result.success());
        } else {
            OnSuccessListener<Location> callback = new OnSuccessListener<Location>() {
                @Override
                public void onSuccess(Location location) {
                    if (location != null) {
                        Thread thread = new Thread(){
                            @Override
                            public void run() {
                                super.run();
                                if(!ProximitiesGeofencingManager.getInstance().isInitialized()){
                                    ProximitiesGeofencingManager.getInstance().init(new WeakReference<>(getApplicationContext()));
                                }
                                ProximitiesGeofencingManager.getInstance().startFromBackground(location);
                                mFuture.set(Result.success());
                            }
                        };
                        thread.start();

                    } else {
                        mFuture.set(Result.success());
                    }
                }
            };
            LocationServices.getFusedLocationProviderClient(getApplicationContext()).getLastLocation()
                    .addOnSuccessListener(callback);
        }

        return mFuture;
    }

}
