package com.proximities.sdk;

import com.proximities.sdk.json.model.animation.AnimationData;
import com.proximities.sdk.json.model.closest_poi.BaseClosestPoi;
import com.proximities.sdk.json.model.feed.BaseFeed;
import com.proximities.sdk.json.model.log.BaseLogResponse;
import com.proximities.sdk.json.model.log.CampaignLogs;
import com.proximities.sdk.json.model.loyalty.BaseLoyalty;
import com.proximities.sdk.json.model.partner.BasePartner;
import com.proximities.sdk.json.model.partner.BasePoi;
import com.proximities.sdk.json.model.transmitter.BaseNfc;
import com.proximities.sdk.json.model.transmitter.BaseQrCode;
import com.proximities.sdk.json.model.transmitter.BaseTransmitterResponse;
import com.proximities.sdk.json.model.transmitter_logs.TransmittersLogs;
import com.proximities.sdk.json.model.user.BaseRegisterUser;

import java.util.Map;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface ProximitiesApiService {

    @GET("api/partners/{lat}/{long}/{radius}")
    Call<BasePartner> getPartnersInRange(@Path("lat") double latitude, @Path("long") double longitude, @Path("radius") int radius);

    @GET("api/pois")
    Call<BasePoi> getPois();

    @GET("api/pois/closest/{lat}/{long}")
    Call<BaseClosestPoi> getClosestPoi(@Path("lat") double latitude, @Path("long") double longitude);

    @GET("api/animations/feed/{lat}/{long}")
    Call<BaseFeed> getFeedPartners(@Path("lat") double latitude, @Path("long") double longitude, @QueryMap Map<String, Object> parameters);

    @GET("api/transmitters/{uuid}/{major}/{minor}")
    Call<BaseTransmitterResponse> getBeacon(@Path("uuid") String uuid, @Path("major") String major, @Path("minor") String minor);

    @GET("api/transmitters/{namespace}/{instance}")
    Call<BaseTransmitterResponse> getEddystone(@Path("namespace") String namespace, @Path("instance") String instance);

    @GET("api/transmitters/{uuid}/{major}/{minor}")
    Call<BaseNfc> getNfc(@Path("uuid") String uuid, @Path("major") String major, @Path("minor") String minor);

    @GET("api/transmitters/{uuid}/{major}/{minor}")
    Call<BaseQrCode> getQrCode(@Path("uuid") String uuid, @Path("major") String major, @Path("minor") String minor);

    @GET("api/users/animations")
    Call<AnimationData> getCampaignsByUserAction(@Query("userAction") String userAction);

    @GET("api/users/animations")
    Call<AnimationData> getFavorites();

    @POST("api/logs/transmitters")
    Call<Void> sendTransmitterLogs(@Body TransmittersLogs logs);

    @POST("api/logs/campaigns")
    Call<BaseLogResponse> postLogs(@Body CampaignLogs logs);

    @POST("api/segmentation/users")
    Call<BaseRegisterUser> registerUser(@Body Map<String, Object> body);

    @POST("api/users/loyalties/{campaignId}/refresh")
    Call<BaseLoyalty> refreshLoyaltyCampaign(@Path("campaignId") int campaignId);

    @POST("api/users/animations/{campaignId}/archive")
    Call<Void> saveCampaign(@Path("campaignId") int campaignId);

    @DELETE("api/users/animations/{campaignId}")
    Call<Void> deleteCampaign(@Path("campaignId") int campaignId);
}
