package com.proximities.sdk.request.api;

import android.content.Context;

import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.interfaces.TransmitterInterface;
import com.proximities.sdk.json.model.partner.BasePartner;
import com.proximities.sdk.json.model.transmitter.BaseTransmitter;
import com.proximities.sdk.json.model.transmitter.Transmitter;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 28/12/14.
 */
public final class TransmitterRequest implements Response.Listener<BaseTransmitter>, Response.ErrorListener {

    private static final String TAG = makeLogTag(TransmitterRequest.class);

    private Context context;
    private TransmitterInterface mCallback;
    private String wsTransmitters;
    private List<Transmitter> transmittersList;

    public TransmitterRequest(Context context, TransmitterInterface callback) {
        this.context = context;
        this.mCallback = callback;
        transmittersList = new ArrayList<>();
        wsTransmitters = BuildConfig.HOST + context.getString(R.string.prxsc_ws_transmitter);
    }

    public void getIBeaconContent(Transmitter transmitter) {
        transmittersList.add(transmitter);
        String url = wsTransmitters + "/" + transmitter.getUuid() + "/" + transmitter.getMajor() + "/" + transmitter.getMinor();
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "GET&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseTransmitter.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    public void getEddystoneContent(Transmitter transmitter) {
        transmittersList.add(transmitter);
        String url = wsTransmitters + "/" + transmitter.getNamespace() + "/" + transmitter.getInstance();
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "GET&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseTransmitter.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseTransmitter baseTransmitter) {
       if(transmittersList.size() > 0){
           transmittersList.remove(0);
       }
       if(baseTransmitter != null && baseTransmitter.getData().getTransmitters().size() > 0 && mCallback != null) {
           mCallback.onGetBeaconContent(baseTransmitter.getData().getTransmitters().get(0));
       }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(mCallback != null && transmittersList.size() > 0){
            mCallback.onGetBeaconError(transmittersList.get(0));
            transmittersList.remove(0);
        }
    }

}
