package com.proximities.sdk.fragment.templates;

import android.annotation.SuppressLint;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.proximities.sdk.R;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;

/**
 * Created by William Mouliné on 22/03/17.
 */

@SuppressLint("SetJavaScriptEnabled")
public class WebviewFragment extends Fragment {

    private TextView title;
    private WebView webview;
    private ProgressBar spinner;
    private Campaign campaign;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = getArguments();
        campaign = bundle.getParcelable(ProximitiesConstants.CAMPAIGN_EXTRA);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.prxsc_template_webview_fragment, container, false);
        title = (TextView) view.findViewById(R.id.title);
        webview = (WebView) view.findViewById(R.id.webview);
        spinner = (ProgressBar) view.findViewById(R.id.spinner);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initWebViewDisplay();
    }

    private void initWebViewDisplay(){
        if (campaign.getTopbarTitle() != null && !campaign.getTopbarTitle().isEmpty()) {
            title.setText(campaign.getTopbarTitle());
            title.setTextColor(Color.parseColor(campaign.getContentFontColor()));
        } else {
            title.setVisibility(View.GONE);
        }
        if(campaign.getWebviewUrl() != null){
            WebSettings settings = webview.getSettings();
            settings.setJavaScriptEnabled(true);
            webview.setWebViewClient(new WebViewClient(){
                @Override
                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    spinner.setVisibility(View.GONE);
                }
            });
            webview.loadUrl(campaign.getWebviewUrl());
        } else {
            spinner.setVisibility(View.GONE);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if(campaign != null && webview != null){
            webview.onResume();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if(campaign != null && webview != null){
            webview.onPause();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if(campaign != null && webview != null){
            webview.destroy();
        }
    }
}
