package com.proximities.sdk.fragment;

import android.support.v4.app.Fragment;

import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.bridge.OnAnimationListener;
import com.proximities.sdk.interfaces.GetFavoritesInterface;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.request.api.AnimationRequest;

import java.util.List;

/**
 * Created by william on 06/11/15.
 */
public class BaseFavoritesFragment extends Fragment implements OnAnimationListener, GetFavoritesInterface{

    private AnimationRequest animationRequest;

    public void refreshFavorites(){
        if(animationRequest == null) {
            animationRequest = new AnimationRequest(getActivity().getApplicationContext(), this);
        }
        animationRequest.executeGet();
    }

    @Override
    public void onClickAnimation(Campaign campaign) {
        campaign.setFavorite(1);
        ProximitiesConfig.getInstance().openCampaign(campaign);
    }

    @Override
    public void onGetFavorites(List<Campaign> favorites) {
        //override in extends fragment
    }

    @Override
    public void onGetFavoritesError() {
        //override in extends fragment
    }
}

