package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.interfaces.QrCodeInterface;
import com.proximities.sdk.json.model.transmitter.BaseQrCode;
import com.proximities.sdk.json.model.transmitter.Transmitter;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;

import java.util.List;
import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 07/09/16.
 */
public final class QRCodeRequest implements Response.Listener<BaseQrCode>, Response.ErrorListener {

    private static final String TAG = makeLogTag(QRCodeRequest.class);
    private Context context;
    private String wsTransmitters;
    private QrCodeInterface mCallback;

    public QRCodeRequest(Context context, QrCodeInterface callback) {
        this.context = context;
        this.mCallback = callback;
        wsTransmitters = BuildConfig.HOST + context.getString(R.string.prxsc_ws_transmitter);
    }


    public void executeGet(String uuid, String major, String minor) {
        String url = wsTransmitters + "/" + uuid + "/" + major + "/" + minor;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "GET&" + url);
        GsonRequest<BaseQrCode> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseQrCode.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseQrCode baseQRCode) {
        if(mCallback != null){
            List<Transmitter> transmitterList = baseQRCode.getData().getTransmitters();
            if(transmitterList != null && transmitterList.size() > 0){
                mCallback.onGetQrCodeTransmitter(transmitterList.get(0));
            } else {
                mCallback.onQrCodeWithoutCampaign();
            }
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(mCallback != null) mCallback.onGetQrCodeError();
    }

}