package com.proximities.sdk.request.api;
import android.content.Context;

import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.json.WsHeader;
import com.proximities.sdk.json.model.partner.BasePartner;
import com.proximities.sdk.json.model.partner.Partner;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import java.util.List;
import java.util.Map;
import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 01/01/15.
 */
public final class PartnerRequest extends WsHeader implements Response.Listener<BasePartner>, Response.ErrorListener {

    private static final String TAG = makeLogTag(PartnerRequest.class);
    private Context context;
    private PartnerInterface mCallback;
    private String wsPartner;

    public PartnerRequest(Context context, PartnerInterface callback) {
        this.context = context;
        this.mCallback = callback;
        wsPartner = BuildConfig.HOST + context.getString(R.string.prxsc_ws_partner);
    }

    public void executeGet(double latitude, double longitude) {
        String url = wsPartner + "/" + latitude + "/" + longitude;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "GET&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                BasePartner.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    public void executeGet(double latitude, double longitude, boolean calledFromGps) {
        String url = wsPartner + "/" + latitude + "/" + longitude;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "GET&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                BasePartner.class,
                params,
                this,
                this,
                calledFromGps);
        //request.setRetryPolicy(new DefaultRetryPolicy(0, DefaultRetryPolicy.DEFAULT_MAX_RETRIES, DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BasePartner basePartner) {
//        EventBus.getDefault().post(basePartner);
        if(mCallback != null && basePartner.getData() != null) mCallback.onGetPartnersSuccess(basePartner.getData().getPartners());
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(mCallback != null) mCallback.onGetPartnersError();
    }

    public interface PartnerInterface{
        void onGetPartnersSuccess(List<Partner> partners);
        void onGetPartnersError();
    }
}
