package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.interfaces.ClosestPoiInterface;
import com.proximities.sdk.json.model.closest_poi.BaseClosestPoi;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 23/11/15.
 */
public final class ClosestPoiRequest implements Response.Listener<BaseClosestPoi>, Response.ErrorListener {

    private static final String TAG = makeLogTag(ClosestPoiRequest.class);
    private Context ctx;
    private ClosestPoiInterface mCallback;
    private String wsClosestPoi;

    public ClosestPoiRequest(Context ctx, ClosestPoiInterface callback) {
        this.ctx = ctx;
        this.mCallback = callback;
        wsClosestPoi = BuildConfig.HOST + ctx.getString(R.string.prxsc_ws_closest_poi);
    }

    public void executeGetForClosestPoi(double latitude, double longitude) {
        String url = wsClosestPoi + "/" + latitude + "/" + longitude;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "GET&" + url);
        GsonRequest<BaseClosestPoi> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseClosestPoi.class,
                params,
                this,
                this);
        request.setRetryPolicy(new DefaultRetryPolicy(DefaultRetryPolicy.DEFAULT_TIMEOUT_MS * 2, DefaultRetryPolicy.DEFAULT_MAX_RETRIES, DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseClosestPoi baseClosestPoi) {
        if(mCallback != null) mCallback.onGetClosestPoi(baseClosestPoi.getData().getDistance());
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(mCallback != null) mCallback.onErrorGetClosestPoi();
    }

}

