package com.proximities.sdk;

import android.Manifest;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.util.Patterns;

import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.integration.android.IntentResult;

import java.util.regex.Pattern;

/**
 * Created by william on 22/08/16.
 */
public class ScannerQrActivity extends Activity{

    private static final int MY_PERMISSIONS_REQUEST_CAMERA = 1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.prxsc_scanner_qr_activity);
        if(ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED){
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.CAMERA},
                    MY_PERMISSIONS_REQUEST_CAMERA);
        } else {
            startScanner();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String permissions[], @NonNull int[] grantResults) {
        switch (requestCode) {
            case MY_PERMISSIONS_REQUEST_CAMERA: {
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    startScanner();
                } else {
                    finish();
                }
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        IntentResult scanResult = IntentIntegrator.parseActivityResult(requestCode, resultCode, intent);
        if (scanResult != null && resultCode == RESULT_OK) {
            handleContentQr(scanResult.getContents());
        } else {
//            if(ProximitiesConfig.getOnResponseFromQrScanListener() != null) ProximitiesConfig.getOnResponseFromQrScanListener().onErrorOnQrCodeResponse();
            finish();
        }
    }

    private void startScanner(){
        IntentIntegrator intentIntegrator = new IntentIntegrator(this);
        intentIntegrator.setDesiredBarcodeFormats(IntentIntegrator.QR_CODE_TYPES);
        intentIntegrator.setCaptureActivity(CapturePortraitActivity.class);
        intentIntegrator.setOrientationLocked(true);
        intentIntegrator.initiateScan();
    }

    private void handleContentQr(String contentQr){
        if(Patterns.WEB_URL.matcher(contentQr).matches()) {
            try {
                contentQr = (!contentQr.startsWith("http://") && !contentQr.startsWith("https://")) ? "http://"+contentQr : contentQr;
                Intent i = new Intent("android.intent.action.MAIN");
                i.setComponent(ComponentName.unflattenFromString("com.android.chrome/com.android.chrome.Main"));
                i.addCategory("android.intent.category.LAUNCHER");
                i.setData(Uri.parse(contentQr));
                startActivity(i);
            }
            catch(ActivityNotFoundException e1) {
                try{
                    Intent i = new Intent(Intent.ACTION_VIEW, Uri.parse(contentQr));
                    startActivity(i);
                } catch (ActivityNotFoundException e2) {
                    if(ProximitiesConfig.getOnResponseFromQrScanListener() != null){
                        ProximitiesConfig.getOnResponseFromQrScanListener().onErrorOnQrCodeResponse();
                    }
                }
            }
        } else {
            if(ProximitiesConfig.getOnResponseFromQrScanListener() != null){
                ProximitiesConfig.getOnResponseFromQrScanListener().onUnknownQrCodeResponse();
            }
        }
        finish();
    }

}
