package com.proximities.sdk;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;

import com.proximities.sdk.activities.EmptyCampaignActivity;
import com.proximities.sdk.interfaces.QrCodeInterface;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.json.model.transmitter.Transmitter;
import com.proximities.sdk.request.api.QRCodeRequest;
import com.proximities.sdk.util.ProximitiesConstants;

/**
 * Created by william on 28/12/16.
 */

class ProximitiesQrCodeManager implements QrCodeInterface {

    private PSManager psManager;
    private Context context;

    ProximitiesQrCodeManager(Context context, Uri uri){
        this.context = context;
        psManager = PSManager.getInstance();
        QRCodeRequest qrCodeRequest = new QRCodeRequest(context, this);
        // http://connect.sweepin.fr/uuid/major/minor/appId
        String[] uriQuery = uri.toString().split("\\/");
        int uriLength = uriQuery.length;
        if(uriLength > 4) {
            String currentUuidNfc = uriQuery[uriLength - 4];
            String currentMajorNfc = uriQuery[uriLength - 3];
            String currentMinordNfc = uriQuery[uriLength - 2];
            qrCodeRequest.executeGet(currentUuidNfc, currentMajorNfc, currentMinordNfc);
        }
    }

    @Override
    public void onGetQrCodeTransmitter(Transmitter transmitter) {
        for(Campaign campaign : transmitter.getCampaigns()){
            campaign.setPoi(transmitter.getPoi().get(0));
        }
        psManager.startCampaignsDisplayFromQRCode(transmitter.getCampaigns(), null, String.valueOf(transmitter.getId()));
    }

    @Override
    public void onQrCodeWithoutCampaign() {
        if(ProximitiesConfig.getOnResponseFromQrScanListener() != null){
            ProximitiesConfig.getOnResponseFromQrScanListener().onNoCampaignOnQrCodeResponse();
        } else {
            Intent intent = new Intent(context, EmptyCampaignActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.putExtra(ProximitiesConstants.FROM_QR_MANAGER_EXTRA, true);
            context.startActivity(intent);
        }
    }

    @Override
    public void onGetQrCodeError() {
        if(ProximitiesConfig.getOnResponseFromQrScanListener() != null){
            ProximitiesConfig.getOnResponseFromQrScanListener().onErrorOnQrCodeResponse();
        }
    }
}
