package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.interfaces.OnGetCampaignsByUserActionListener;
import com.proximities.sdk.json.model.animation.AnimationData;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;

import java.util.ArrayList;
import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by William Mouliné on 11/09/17.
 */

public class CampaignsByUserActionRequest implements Response.Listener<AnimationData>, Response.ErrorListener {

    private static final String TAG = makeLogTag(CampaignsByUserActionRequest.class);

    private Context mContext;
    private OnGetCampaignsByUserActionListener mCallback;

    public CampaignsByUserActionRequest(Context context, OnGetCampaignsByUserActionListener callback){
        this.mContext = context;
        this.mCallback = callback;
    }

    public void requestCampaignsByUserAction(String userAction) {
        String url = BuildConfig.HOST + mContext.getString(R.string.prxsc_ws_favorites) + "?userAction=" + userAction;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(mContext, "GET&" + url);
        GsonRequest<AnimationData> request = new GsonRequest(
                Request.Method.GET,
                url,
                AnimationData.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(AnimationData response) {
        if(mCallback != null){
            mCallback.onGetCampaignsByUserAction((response.getData() != null) ? response.getData().getCampaigns() : new ArrayList<Campaign>());
        }
    }

    @Override
    public void onErrorResponse(VolleyError error) {
        if(mCallback != null){
            mCallback.onGetCampaignsByUserActionError();
        }
    }
}
