package com.proximities.sdk.request.api;

import android.content.Context;

import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.json.model.user.BaseRegisterUser;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by victo_000 on 21/12/2014.
 */
public class RegisterUserRequest implements Response.Listener<BaseRegisterUser>, Response.ErrorListener{

    private static final String TAG = makeLogTag(RegisterUserRequest.class);
    private Context context;
    private String wsSegUser;

    public RegisterUserRequest(Context context) {
        this.context = context;
        wsSegUser = BuildConfig.HOST + context.getString(R.string.prxsc_ws_user_seg);
    }

    public void sendRegisterUser(Map<String, Object> body) {
        LOGD(TAG, "POST : " + wsSegUser);
        Map<String, String> params = Header.getInstance().makeHeader(context, "POST&" + wsSegUser);
        GsonRequest<BaseRegisterUser> request = new GsonRequest(
                Request.Method.POST,
                wsSegUser,
                body,
                BaseRegisterUser.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    public void updateRegisterUser(Map<String, Object> body) {
        LOGD(TAG, "PUT: " + wsSegUser);
        Map<String, String> params = Header.getInstance().makeHeader(context, "PUT&" + wsSegUser);
        GsonRequest<BaseRegisterUser> request = new GsonRequest(
                Request.Method.PUT,
                wsSegUser,
                body,
                BaseRegisterUser.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
    }

    @Override
    public void onResponse(BaseRegisterUser baseUser) {
    }
}