package com.proximities.sdk.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.bridge.OnAnimationListener;
import com.proximities.sdk.bridge.OnCustomClick;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 05/01/14.
 */
public class FavoriteListAdapter extends RecyclerView.Adapter<FavoriteListAdapter.AnimationViewHolder> implements OnCustomClick {

    private static final int HEIGHT_IMAGE = 75;
    private Context ctx;
    private List<Campaign> campaigns;
    private OnAnimationListener listener;

    public static class AnimationViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        protected OnCustomClick myListener;
        protected ImageView image;
        protected ImageView banner;
        protected LinearLayout textPart;
        protected TextView title;
        protected TextView topbarTitle;
        protected WebView content;

        public AnimationViewHolder(View itemView, OnCustomClick listener) {
            super(itemView);
            itemView.setOnClickListener(this);
            myListener = listener;
            image = (ImageView) itemView.findViewById(R.id.image);
            banner = (ImageView) itemView.findViewById(R.id.banner);
            textPart = (LinearLayout) itemView.findViewById(R.id.text_part);
            title = (TextView) itemView.findViewById(R.id.title);
            topbarTitle = (TextView) itemView.findViewById(R.id.topbar_title);
            content = (WebView) itemView.findViewById(R.id.content);
        }

        @Override
        public void onClick(View view) {
            myListener.onClickAt(getAdapterPosition());
        }
    }

    public FavoriteListAdapter(Context context, List<Campaign> campaigns, OnAnimationListener listener) {
        this.ctx = context;
        this.listener = listener;
        if (campaigns == null) {
            this.campaigns = new ArrayList<>();
        } else {
            this.campaigns = campaigns;
        }
    }

    @Override
    public AnimationViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.
                from(parent.getContext()).
                inflate(R.layout.prxsc_favorites_item, parent, false);
        return new FavoriteListAdapter.AnimationViewHolder(itemView, this);
    }

    @Override
    public void onBindViewHolder(final AnimationViewHolder holder,final int position) {
        Campaign campaign = campaigns.get(position);
        int textColor = ContextCompat.getColor(ctx, android.R.color.black);  // TODO define a default content font color
        if (campaign.getContentFontColor() != null && !campaign.getContentFontColor().isEmpty()) {
            textColor = Color.parseColor(campaign.getContentFontColor());
        }

        if (campaign.getContentBackgroundColor() != null && !campaign.getContentBackgroundColor().isEmpty()) {
            holder.textPart.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
        }
        if (campaign.getTemplateType().equals(ProximitiesConfig.AUDIO_CAMPAIGN) || campaign.getTemplateType().equals(ProximitiesConfig.WEB_CAMPAIGN)) {

            holder.topbarTitle.setVisibility(View.GONE);
            holder.content.setVisibility(View.GONE);
            holder.banner.setVisibility(View.GONE);
            holder.textPart.setBackgroundColor(ColorUtils.setAlphaComponent(ContextCompat.getColor(ctx, android.R.color.black), 0x99));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
            holder.textPart.setLayoutParams(params);

            params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            holder.image.setLayoutParams(params);

            String url = ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getImage();
            if(campaign.getTemplateType().equals(ProximitiesConfig.AUDIO_CAMPAIGN)){
                loadImageFullSize(url, holder, R.drawable.default_audio);
            } else if(campaign.getTemplateType().equals(ProximitiesConfig.WEB_CAMPAIGN)) {
                loadImageFullSize(url, holder, R.drawable.default_webview);
            }

            holder.title.setVisibility(View.VISIBLE);
            holder.title.setText(campaign.getTopbarTitle());
            //holder.title.setTextColor(Color.parseColor(campaign.getTopbarFontColor()));
            holder.title.setTextColor(ContextCompat.getColor(ctx, android.R.color.white));
           // holder.textPart.setBackgroundColor(ColorUtils.setAlphaComponent(Color.parseColor(campaign.getTopbarBackgroundColor()), 0xAA));

        }else{
            //RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, 75);
            //holder.image.setLayoutParams(params);
            holder.title.setVisibility(View.GONE);
            RelativeLayout.LayoutParams paramsImg = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, dpToPxl(HEIGHT_IMAGE));
            paramsImg.addRule(RelativeLayout.BELOW, holder.banner.getId());
            holder.image.setLayoutParams(paramsImg);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            params.addRule(RelativeLayout.BELOW, holder.image.getId());
            holder.textPart.setLayoutParams(params);


            if (campaign.getBanner() != null && !campaign.getBanner().isEmpty()) {
                holder.banner.setVisibility(View.VISIBLE);
                String url = ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getBanner();
                //Glide.with(ctx).load(url).placeholder(R.drawable.loading).centerCrop().diskCacheStrategy(DiskCacheStrategy.ALL).into(holder.banner);
                Glide.with(ctx).load(url).asBitmap().placeholder(R.drawable.loading).diskCacheStrategy(DiskCacheStrategy.ALL)
                        .into(new SimpleTarget<Bitmap>() {
                            @Override
                            public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                                holder.banner.setImageBitmap(resource);
                            }

                            @Override
                            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                                super.onLoadFailed(e, errorDrawable);
                                holder.banner.setVisibility(View.GONE);
                            }
                        });
                holder.banner.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
            } else {
                holder.banner.setVisibility(View.GONE);
            }
            if (campaign.getImage() != null && !campaign.getImage().isEmpty()) {
                holder.image.setVisibility(View.VISIBLE);
                String url = ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getImage();
                Glide.with(ctx).load(url).asBitmap().placeholder(R.drawable.loading).diskCacheStrategy(DiskCacheStrategy.ALL)
                        .into(new SimpleTarget<Bitmap>() {
                            @Override
                            public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                                holder.image.setImageBitmap(resource);
                            }

                            @Override
                            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                                super.onLoadFailed(e, errorDrawable);
                                holder.image.setVisibility(View.GONE);
                            }
                        });
                //Glide.with(ctx).load(url).placeholder(R.drawable.loading).centerCrop().diskCacheStrategy(DiskCacheStrategy.ALL).into(holder.image);
                holder.image.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
            } else {
                holder.image.setVisibility(View.GONE);
            }
            if (campaign.getTopbarTitle() != null && !campaign.getTopbarTitle().isEmpty()) {
                holder.topbarTitle.setVisibility(View.VISIBLE);
                holder.topbarTitle.setText(campaign.getTopbarTitle());
                holder.topbarTitle.setTextColor(Color.parseColor(campaign.getTopbarFontColor()));
                holder.topbarTitle.setBackgroundColor(Color.parseColor(campaign.getTopbarBackgroundColor()));
            } else {
                holder.topbarTitle.setVisibility(View.GONE);
            }
            if (campaign.getContentText() != null && !campaign.getContentText().isEmpty()) {
                WebSettings webSettings = holder.content.getSettings();
                webSettings.setDefaultFontSize(10);
                String myHtml = "<html><head>"
                        + "<style type=\"text/css\">body{color: " + campaign.getContentFontColor() + ";}"
                        + "</style>"
                        + "</head>"
                        + "<body>"
                        + campaign.getContentText()
                        + "</body></html>";
                holder.content.loadDataWithBaseURL(null, myHtml, "text/html", "UTF-8", null);
                holder.content.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
                holder.content.setVisibility(View.VISIBLE);
                holder.content.setOnTouchListener(new View.OnTouchListener() {
                    @Override
                    public boolean onTouch(View v, MotionEvent event) {
                        listener.onClickAnimation(campaigns.get(position));
                        return false;
                    }
                });
                //holder.content.setText(Html.fromHtml(campaign.getContentText()));
                //holder.content.setText(Html.fromHtml(campaign.getContentText()));
                //holder.content.setTextColor(textColor);
            } else {
                holder.content.setVisibility(View.GONE);
            }
        }
    }

    private void loadImageFullSize(String url, final AnimationViewHolder holder,final  int resource){
        Glide.with(ctx).load(url).asBitmap().placeholder(resource).diskCacheStrategy(DiskCacheStrategy.ALL)
                .into(new SimpleTarget<Bitmap>() {
                    @Override
                    public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                        holder.image.setImageBitmap(resource);
                    }

                    @Override
                    public void onLoadFailed(Exception e, Drawable errorDrawable) {
                        super.onLoadFailed(e, errorDrawable);
                        holder.image.setImageDrawable(ContextCompat.getDrawable(ctx, resource));
                    }
                });
    }

    private int dpToPxl(int dp){
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, ctx.getResources().getDisplayMetrics());
    }

    @Override
    public int getItemCount() {
        return campaigns.size();
    }

    @Override
    public void onClickAt(int position) {
        listener.onClickAnimation(campaigns.get(position));
    }

}