package com.proximities.sdk.util;

import android.app.AlertDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.proximities.sdk.R;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 19/11/14.
 */
public abstract class Utils {

    public static String getCurrentLanguage(Context ctx) {
        return ctx.getResources().getConfiguration().locale.getLanguage();
    }

    public static String roundDistance(float distance) {
        double newDist = Math.floor(distance * 100) / 100;
        return String.valueOf(newDist);
    }

    /**
     * To load dynamic resource with the given name
     *
     * @param name the string resource we want to load
     * @param context context of the activity
     * @return the id of R file which corresponds to this drawable
     */
    public static int getResourceAsDrawable(String name, Context context) {
        int drawResourceID = context.getResources().getIdentifier(name, "drawable", context.getApplicationInfo().packageName);
        return drawResourceID;
    }

    public static void showErrorDialog(Context context, String text){
        LayoutInflater factory = LayoutInflater.from(context);
        final View dialogView = factory.inflate(R.layout.error_dialog, null);
        final AlertDialog dialog = new AlertDialog.Builder(context).create();
        dialog.setView(dialogView);

        final TextView errorText = (TextView) dialogView.findViewById(R.id.text_error);
        errorText.setText(text);

        final Button buttonOk = (Button) dialogView.findViewById(R.id.btn_ok);
        buttonOk.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });

        dialog.show();
    }

    public static String getAppId(Context ctx) {
        return getMetaData(ctx).getString("proximities:appId");
    }

    public static String getAppSecret(Context ctx) {
        return getMetaData(ctx).getString("proximities:appSecret");
    }

    /**
     * Get application meta-data of a package name.
     *
     * @param context application context.
     * @return meta-data, may be empty but never null.
     */
    public static Bundle getMetaData(Context context) {
        Bundle config;
        try {
            config = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA).metaData;
            if (config == null) {
                config = new Bundle();
            }
        } catch (Exception e) {
            /*
             * NameNotFoundException or in some rare scenario an undocumented "RuntimeException: Package
             * manager has died.", probably caused by a system app process crash.
             */
            config = new Bundle();
        }
        return config;
    }

    public static boolean isColorDark(int color){
        double darkness = 1-(0.299* Color.red(color) + 0.587*Color.green(color) + 0.114*Color.blue(color))/255;
        if(darkness<0.5){
            return false; // It's a light color
        }else{
            return true; // It's a dark color
        }
    }

    public static boolean isIncompatibleDevice(){
        return (Build.MANUFACTURER.toLowerCase().contains("infinix") || Build.MODEL.toLowerCase().contains("infinix")) && android.os.Build.VERSION.SDK_INT == Build.VERSION_CODES.M;
    }
}
