package com.proximities.sdk.request.api;

import android.app.Application;

import com.proximities.sdk.database.DatabaseHandler;
import com.proximities.sdk.json.WsHeader;
import com.proximities.sdk.json.model.log.AddedLog;
import com.proximities.sdk.json.model.log.AnimationLog;
import com.proximities.sdk.json.model.partner.BasePartner;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.LogUtils;
import com.proximities.sdk.util.ProximitiesConstants;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import java.util.ArrayList;
import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 01/01/15.
 */
public final class LogRequest implements Response.Listener<WsHeader>, Response.ErrorListener {

    private static final String TAG = LogUtils.makeLogTag(LogRequest.class);

    private static LogRequest ourInstance;
    private Application ctx;
    private AnimationLog animLog;
    private boolean isFromDatabase;

    public static LogRequest getInstance(Application ctx) {
        if (ourInstance == null) {
            ourInstance = new LogRequest(ctx);
        }
        return ourInstance;
    }

    private LogRequest() {}
    private LogRequest(Application ctx) {
        this.ctx = ctx;
    }

    public void executePost(AnimationLog logs) {
        if(logs != null && logs.getAnimationsIds() != null && logs.getAnimationsIds().size() > 0) {
            isFromDatabase = false;
            animLog = logs;
            String url = ProximitiesConstants.access().getWS_LOGS();
            LOGD(TAG, "POST : " + url);
            Map<String, String> params = Header.getInstance().makeHeader(ctx, "POST&" + url);
            LOGD(TAG, "userAction : " + logs.getUserAction());
            GsonRequest<BasePartner> request = new GsonRequest(
                    Request.Method.POST,
                    url,
                    logs,
                    WsHeader.class,
                    params,
                    this,
                    this);
            ApplicationUtil.getMyInstance().getRequestQueue().add(request);
        }
    }

    public void executePostFromDatabase(Map<String, ArrayList<Map<String, String>>> body) {
        if(body != null) {
            isFromDatabase = true;
            String url = ProximitiesConstants.access().getWS_LOGS();
            LOGD(TAG, "POST : " + url);
            Map<String, String> params = Header.getInstance().makeHeader(ctx, "POST&" + url);
            GsonRequest<BasePartner> request = new GsonRequest(
                    Request.Method.POST,
                    url,
                    body,
                    WsHeader.class,
                    params,
                    this,
                    this);
            ApplicationUtil.getMyInstance().getRequestQueue().add(request);
        }
    }

    @Override
    public void onResponse(WsHeader wsHeader) {
        if(isFromDatabase) EventBus.getDefault().post(new AddedLog());
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        insertLogInDatabase();
    }

    private void insertLogInDatabase(){
        if(animLog != null && animLog.getAnimationsIds() != null) {
            DatabaseHandler db = new DatabaseHandler(ctx.getApplicationContext());
            db.insertLogsIntoDatabase(animLog.getAnimationsIds().get(0), animLog.getUserAction());
            db.close();
        }
    }

    private void deleteLogFromDatabase(){

    }
}
