package com.proximities.sdk.request.api;

import android.app.Application;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.json.model.feed.BaseFeed;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 08/12/15.
 */
public final class FeedRequest implements Response.Listener<BaseFeed>, Response.ErrorListener {

    private static final String TAG = makeLogTag(FeedRequest.class);

    private static FeedRequest ourInstance;

    public static FeedRequest getInstance() {
        if (ourInstance == null) {
            ourInstance = new FeedRequest();
        }
        return ourInstance;
    }

    private FeedRequest() {
    }

    public void executeGet(double latitude, double longitude, int page, int nbElmts){
        String url = ProximitiesConstants.access().getWS_FEED() + "/" + latitude + "/" + longitude+"?page=" + page + "&size=" + nbElmts;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ApplicationUtil.getMyInstance().getMyApp(), "GET&" + url);
        GsonRequest<BaseFeed> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseFeed.class,
                params,
                this,
                this);
        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    public void executeGet(String url){
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ApplicationUtil.getMyInstance().getMyApp(), "GET&" + url);
        GsonRequest<BaseFeed> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseFeed.class,
                params,
                this,
                this);
        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseFeed baseFeed) {
        ProximitiesConstants.STATIC_CONTENT_HOST = baseFeed.getServerUrl();
        if(ProximitiesConfig.getOnRetrievePartnersListener() != null){
            ProximitiesConfig.getOnRetrievePartnersListener().onRetrievePartners(baseFeed.getData().getPartners());
        }
    }

    @Override
    public void onErrorResponse(VolleyError error) {
        if(ProximitiesConfig.getOnRetrievePartnersListener() != null){
            ProximitiesConfig.getOnRetrievePartnersListener().onRetrievePartnersError(new String(error.networkResponse.data));
        }
    }
}
