package com.proximities.sdk.request.api;

import android.app.Activity;

import com.proximities.sdk.json.model.category.ExcludedCategoriesSuccess;
import com.proximities.sdk.json.model.error.ErrorData;
import com.proximities.sdk.json.model.partner.ExcludedBasePartner;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.google.gson.Gson;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by victo_000 on 29/01/2015.
 */
public class ExcludedBrandRequest implements Response.Listener<ExcludedBasePartner>, Response.ErrorListener {
    private static final String TAG = makeLogTag(ExcludedBrandRequest.class);

    private static ExcludedBrandRequest ourInstance;
    private static int methodHttp;
    private Activity ctx;

    public static ExcludedBrandRequest getInstance(Activity ctx) {
        if (ourInstance == null) {
            ourInstance = new ExcludedBrandRequest(ctx);
        }
        return ourInstance;
    }

    private ExcludedBrandRequest() {}
    private ExcludedBrandRequest(Activity ctx) {
        this.ctx = ctx;
    }

    public void executeGet() {
        methodHttp = Request.Method.GET;
        String url = ProximitiesConstants.access().getWS_EXCLUDED_PARTNERS();
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "GET&" + url);
        GsonRequest<ExcludedBasePartner> request = new GsonRequest(
                Request.Method.GET,
                url,
                ExcludedBasePartner.class,
                params,
                this,
                this);
        request.setShouldCache(false);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    public void executePost(List<Integer> excludedBrands) {
        methodHttp = Request.Method.POST;
        String url = ProximitiesConstants.access().getWS_EXCLUDED_BRANDS();
        LOGD(TAG, "POST : " + url);
        Map<String, String> params = Header.getInstance().makeHeaderWithoutAnonymous(ctx, "POST&" + url);
        Map<String, List<Integer>> body = new HashMap<>();
        body.put("datas", excludedBrands);
        GsonRequest<ExcludedBasePartner> request = new GsonRequest(
                Request.Method.POST,
                url,
                body,
                ExcludedBasePartner.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    private String getBodyString(List<Integer> excludedBrands) {
        String bodyString = "[";
        for(int i = 0; i < excludedBrands.size(); i++) {
            if(i == 0) {
                bodyString += "\"" + excludedBrands.get(i) + "\"";
            } else {
                bodyString += ", \"" + excludedBrands.get(i) + "\"";
            }
        }
        bodyString += "]";
        return bodyString;
    }

    @Override
    public void onResponse(ExcludedBasePartner result) {
        if(result != null) {
            EventBus.getDefault().post(result);
        } else {
            EventBus.getDefault().post(new ExcludedCategoriesSuccess());
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        NetworkResponse response = volleyError.networkResponse;
        if (response != null && response.data != null) {
            switch (response.statusCode) {
                case 400 :
                    ErrorData errorData = new Gson().fromJson(new String(response.data), ErrorData.class);
                    errorData.setStatusCode(response.statusCode);
                    EventBus.getDefault().post(errorData);
                    break;
            }
        }
    }
}