package com.proximities.sdk.request.api;

import android.app.Application;

import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.google.gson.Gson;
import com.proximities.sdk.json.WsHeader;
import com.proximities.sdk.json.model.error.ErrorData;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.LogUtils;
import com.proximities.sdk.util.ProximitiesConstants;

import org.greenrobot.eventbus.EventBus;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by william on 08/02/16.
 */
public class EntryExitLogRequest implements Response.Listener<WsHeader>, Response.ErrorListener  {

    private static final String TAG = LogUtils.makeLogTag(EntryExitLogRequest.class);
    private static EntryExitLogRequest ourInstance;
    private Application ctx;
    private boolean isEntryLog = false;
    private boolean isExitLog = false;


    public static EntryExitLogRequest getInstance(Application ctx) {
        if (ourInstance == null) {
            ourInstance = new EntryExitLogRequest(ctx);
        }
        return ourInstance;
    }

    private EntryExitLogRequest() {}
    private EntryExitLogRequest(Application ctx) {
        this.ctx = ctx;
    }

    public void executeEntryPost(String[] beaconDetails) {
        isEntryLog = true;
        isExitLog = false;
        String url = ProximitiesConstants.access().getWS_ENTRY_LOGS();
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "POST&" + url);
        GsonRequest<WsHeader> request = new GsonRequest(
                Request.Method.POST,
                url,
                setParameters(beaconDetails),
                WsHeader.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    public void executeExitPost(String[] beaconDetails) {
        isEntryLog = false;
        isExitLog = true;
        String url = ProximitiesConstants.access().getWS_EXIT_LOGS();
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "POST&" + url);
        GsonRequest<WsHeader> request = new GsonRequest(
                Request.Method.POST,
                url,
                setParameters(beaconDetails),
                WsHeader.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(WsHeader response) {
        if(isExitLog){

        }
    }

    @Override
    public void onErrorResponse(VolleyError error) {
        NetworkResponse response = error.networkResponse;
        if (response != null && response.data != null) {
            switch (response.statusCode) {
                case 400 :
                    ErrorData errorData = new Gson().fromJson(new String(response.data), ErrorData.class);
                    errorData.setStatusCode(response.statusCode);
                    EventBus.getDefault().post(errorData);
                    break;
            }
        }
    }

    private Map<String, ArrayList<Map<String, String>>> setParameters(String[] beaconLog){
            Map<String, ArrayList<Map<String, String>>> body = new HashMap<>();
            ArrayList<Map<String, String>> logs = new ArrayList<>();
            Map<String, String> log = new HashMap<>();
            log.put("uuid", beaconLog[0]);
            log.put("major", beaconLog[1]);
            log.put("minor", beaconLog[2]);
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            log.put("created", format.format(calendar.getTime()));
            logs.add(log);
            body.put("logs", logs);
            return body;
    }
}
