package com.proximities.sdk.fragment.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.widget.CheckBox;

import com.proximities.sdk.R;
import com.proximities.sdk.util.ProximitiesPrefs;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 02/01/15.
 */
public class BluetoothFragment extends DialogFragment {

    private static BluetoothClickListener bluetoothCallback;

    public interface BluetoothClickListener {
        public void onBluetoothEnabled(boolean enabled);
    }

    public static BluetoothFragment newInstance() {
        BluetoothFragment dlg = new BluetoothFragment();
        return dlg;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            bluetoothCallback = (BluetoothClickListener) activity;
        } catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement BluetoothClickListener");
        }
    }

    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        super.onDismiss(dialogInterface);
        bluetoothCallback.onBluetoothEnabled(false);
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        // Get the layout inflater
        LayoutInflater inflater = getActivity().getLayoutInflater();
        builder.setTitle(R.string.bluetooth)
                .setView(inflater.inflate(R.layout.bluetooth_dialog, null))
                .setNegativeButton(R.string.disagree, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int id) {
                        AlertDialog alertDialog = (AlertDialog) dialog;
                        CheckBox cb = (CheckBox) alertDialog.findViewById(R.id.checkbox);
                        if (cb.isChecked()) {  // do not ask again
                            ProximitiesPrefs.writeAskBleAgain(getActivity(), false);
                        }
                        bluetoothCallback.onBluetoothEnabled(false);
                    }
                })
                .setPositiveButton(R.string.agree, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int id) {
                        AlertDialog alertDialog = (AlertDialog) dialog;
                        CheckBox cb = (CheckBox) alertDialog.findViewById(R.id.checkbox);
                        if (cb.isChecked()) {  // do not ask again
                            ProximitiesPrefs.writeAskBleAgain(getActivity(), false);
                        }
                        bluetoothCallback.onBluetoothEnabled(true);
                    }
                });
        return builder.create();
    }
}
