package com.proximities.sdk.fragment;


import android.content.Intent;
import android.support.v4.app.Fragment;

import com.proximities.sdk.ProximitiesAnimationActivity;
import com.proximities.sdk.bridge.OnAnimationListener;
import com.proximities.sdk.json.model.animation.AnimationData;
import com.proximities.sdk.json.model.animation.ErrorAnimation;
import com.proximities.sdk.json.model.log.AddedLog;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.request.api.AnimationRequest;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.ArrayList;
import java.util.List;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

/**
 * Created by william on 06/11/15.
 */
public class BaseFavoritesFragment extends Fragment implements OnAnimationListener{

    public void refreshFavorites(){
        AnimationRequest.getInstance(getActivity().getApplication()).executeGet();
    }

    @Override
    public void onClickAnimation(Campaign anim) {
        Intent intent = new Intent(getActivity(), ProximitiesAnimationActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        ArrayList<Campaign> anims = new ArrayList<>();
        anims.add(anim);
        intent.putExtra(ProximitiesConstants.EXTRA_ANIMS, anims);
        intent.putExtra(ProximitiesConstants.EXTRA_ACTION_BUTTON_VALUE, 1);
        intent.putExtra(ProximitiesConstants.EXTRA_DELETE_OPTION, true);
        startActivity(intent);
    }

    public void onReceiveFavorites(List<Campaign> favorites) {

    }
    
    public void onErrorCallbackFavorites() {

    }

    /**
     * Callback on GET {@link ProximitiesConstants#WS_ANIM} with success
     *
     * @param data  {@link AnimationData} object
     */
    @Subscribe
    public void onEventMainThread(AnimationData data) {
        if (data.getData() != null && data.getData().getCampaigns() != null && data.getData().getCampaigns().size() > 0) {
            onReceiveFavorites(data.getData().getCampaigns());
        } else {
            onReceiveFavorites(null);
        }
    }

    /**
     * Callback on GET {@link ProximitiesConstants#WS_ANIM} with error
     *
     * @param data  {@link ErrorAnimation} object
     */
    @Subscribe
    public void onEventMainThread(ErrorAnimation data) {
        onErrorCallbackFavorites();
    }

    /**
     * Callback on POST {@link com.proximities.sdk.util.ProximitiesConstants#WS_LOGS} with success
     *
     * @param data  {@link AddedLog} object
     * @see com.proximities.sdk.request.api.LogRequest
     */
    @Subscribe
    public void onEventMainThread(AddedLog data) {
        refreshFavorites();
    }

    @Override
    public void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    public void onStop() {
        EventBus.getDefault().unregister(this);
        super.onStop();
    }

}
