package com.proximities.sdk.fragment;

import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.util.Base64;
import android.util.Patterns;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.bridge.OnUrlRequestListener;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.concurrent.TimeUnit;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

/**
 * Created by william on 23/09/15.
 */
public class AudioAnimation extends Fragment{

    private ImageView image;
    private ImageView arrow;
    private RelativeLayout titleLayout;
    private RelativeLayout textPart;
    private ImageView playOrPause;
    private TextView progressTime;
    private TextView duration;
    private TextView title;
    private SeekBar timeline;
    private WebView content;
    private ProgressBar spinner;
    private static OnUrlRequestListener urlRequestListener;
    private boolean isAnimOpened = false;
    private MediaPlayer mediaPlayer;
    private Handler durationHandler = new Handler();
    private boolean isContentHidden = false;
    private boolean isImageLoaded = false;
    private boolean isWebViewLoaded = false;

    private Campaign campaign;
    private int timeElapsed = 0;
    private boolean isMediaPrepared = false;

    public static AudioAnimation newInstance(OnUrlRequestListener OnUrlRequestListener) {
        urlRequestListener = OnUrlRequestListener;
        AudioAnimation fragment = new AudioAnimation();
        return fragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.audio_animation_fragment, container, false);
        image = (ImageView) v.findViewById(R.id.image);
        arrow = (ImageView) v.findViewById(R.id.arrow);
        titleLayout = (RelativeLayout) v.findViewById(R.id.title_layout);
        textPart = (RelativeLayout) v.findViewById(R.id.text_part);
        title = (TextView) v.findViewById(R.id.title);
        progressTime = (TextView) v.findViewById(R.id.progress_time);
        duration = (TextView) v.findViewById(R.id.duration_media);
        timeline = (SeekBar) v.findViewById(R.id.timeline);
        content = (WebView) v.findViewById(R.id.content);
        playOrPause = (ImageView) v.findViewById(R.id.playOrPause);
        spinner = (ProgressBar) v.findViewById(R.id.spinner);
        //Typeface font = Typeface.createFromAsset(getActivity().getAssets(), "fontawesome-webfont.ttf");
        //playOrPause.setTypeface(font);
        //arrow.setTypeface(font);

        arrow.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!isContentHidden){
                    //arrow.setText(getResources().getString(R.string.icn_arrow_up));
                    arrow.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_arrow_up));
                    textPart.animate().translationYBy(textPart.getHeight() - titleLayout.getHeight()).start();
                    isContentHidden = true;
                } else {
                    //arrow.setText(getResources().getString(R.string.icn_arrow_down));
                    arrow.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_arrow_down));
                    textPart.animate().translationYBy(-textPart.getHeight() + titleLayout.getHeight()).start();
                    isContentHidden = false;
                }
            }
        });
        return v;
    }

    private int dpToPxl(int dp){
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, getResources().getDisplayMetrics());
    }

    /**
     * Retrieve informations sent by {@link com.proximities.sdk.ProximitiesAnimationActivity}
     *
     * @param data  {@link Campaign} object
     */
    @Subscribe(sticky = true)
    public void onEventMainThread(Campaign data) {
        if(!isAnimOpened) {
            campaign = data;
            isAnimOpened = true;
            if (campaign.getTemplateType() != null) {
                if (campaign.getTemplateType().equals(ProximitiesConstants.AUDIO_NOTIF)) {
                    displayAudioAnimation();
                }
            }
        }
    }

    private void changeSeekbarColor(SeekBar s,int colorp, int colors) {
        try{
            PorterDuff.Mode mMode = PorterDuff.Mode.SRC_ATOP;

            LayerDrawable layerDrawable = (LayerDrawable) s.getProgressDrawable();
            Drawable progress = (Drawable) layerDrawable.findDrawableByLayerId(android.R.id.progress);
            Drawable secondary = (Drawable) layerDrawable.findDrawableByLayerId(android.R.id.background);
            if (getActivity().getResources().getConfiguration().orientation != Configuration.ORIENTATION_LANDSCAPE) {
                progress.setColorFilter(colorp, mMode);
                secondary.setColorFilter(colors, mMode);
            }else {
                progress.setColorFilter(ContextCompat.getColor(getActivity(), android.R.color.white), mMode);
                secondary.setColorFilter(ColorUtils.setAlphaComponent(ContextCompat.getColor(getActivity(), android.R.color.white), 0x77), mMode);
            }
            layerDrawable.setDrawableByLayerId(android.R.id.progress, progress);
            layerDrawable.setDrawableByLayerId(android.R.id.background, secondary);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    private void displayAudioAnimation(){
        int textColor = ContextCompat.getColor(getActivity(), android.R.color.black);  // TODO define a default content font color
        if (campaign.getContentFontColor() != null && !campaign.getContentFontColor().isEmpty()) {
            textColor = Color.parseColor(campaign.getContentFontColor());
        }

        changeSeekbarColor(timeline, textColor, ColorUtils.setAlphaComponent(textColor, 0x77));

        //playOrPause.setTextColor(textColor);
        //arrow.setTextColor(textColor);
        arrow.setColorFilter(new PorterDuffColorFilter(textColor, PorterDuff.Mode.MULTIPLY));
        playOrPause.setColorFilter(new PorterDuffColorFilter(textColor, PorterDuff.Mode.MULTIPLY));
        progressTime.setTextColor(textColor);
        duration.setTextColor(textColor);
        //spinner.getProgressDrawable().setColorFilter(textColor, PorterDuff.Mode.SRC_IN);

        if (campaign.getContentTitle() != null && !campaign.getContentTitle().isEmpty()) {
            //title.setVisibility(View.VISIBLE);
            title.setText(campaign.getContentTitle());
            title.setTextColor(textColor);
        } else {
            title.setVisibility(View.GONE);
        }

        if (campaign.getImage() != null && !campaign.getImage().isEmpty()) {
            image.setVisibility(View.VISIBLE);
            String url = ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getImage();
            Glide.with(getActivity()).load(url)
                    .asBitmap()
                    .into(new SimpleTarget<Bitmap>() {
                        @Override
                        public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                            image.setImageBitmap(resource);
                            isImageLoaded = true;
                            checkIfEveryThingIsLoaded();
                        }

                        @Override
                        public void onLoadFailed(Exception e, Drawable errorDrawable) {
                            if(campaign.getImageOffline()!= null && !campaign.getImageOffline().isEmpty()) {
                                byte[] decodedString = Base64.decode(campaign.getImageOffline(), Base64.DEFAULT);
                                image.setImageBitmap(BitmapFactory.decodeByteArray(decodedString, 0, decodedString.length));
                            }
                            isImageLoaded = true;
                            checkIfEveryThingIsLoaded();
                            super.onLoadFailed(e, errorDrawable);
                        }
                    });
            image.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
        } else {
            isImageLoaded = true;
            image.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.default_audio));
            checkIfEveryThingIsLoaded();
        }

        if (campaign.getContentText() != null && !campaign.getContentText().isEmpty()) {
            content.setVisibility(View.VISIBLE);
            content.setBackgroundColor(Color.TRANSPARENT);
            String myHtml = "<html><head>"
                    + "<style type=\"text/css\">body{color: " + campaign.getContentFontColor() + ";}"
                    + "</style>"
                    + "</head>"
                    + "<body>"
                    + campaign.getContentText()
                    + "</body></html>";
            content.loadDataWithBaseURL(null, myHtml, "text/html", "UTF-8", null);
            content.setWebViewClient(new WebViewClient() {
                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if(Patterns.WEB_URL.matcher(url).matches()) {
                        boolean isUrlHandled = false;
                        if(ProximitiesConfig.getInstance() != null){
                            if(ProximitiesConfig.getOnCampaignURLClickListener() != null) isUrlHandled = ProximitiesConfig.getOnCampaignURLClickListener().onCampaignURLCLick(url);
                            else if(ProximitiesConfig.getOnItemWebViewClickListener() != null) isUrlHandled = ProximitiesConfig.getOnItemWebViewClickListener().onItemWebViewClick(url);
                        }
                        if(!isUrlHandled) urlRequestListener.displayUrlView(url);
                    } else {
                        Intent callIntent = new Intent(Intent.ACTION_DIAL);
                        callIntent.setData(Uri.parse("tel:" + url));
                        startActivity(callIntent);
                    }
                    return true;
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    isWebViewLoaded = true;
                    checkIfEveryThingIsLoaded();
                    super.onPageFinished(view, url);
                }
            });
            // content.setText(Html.fromHtml(campaign.getContentText()));
            // content.setTextColor(textColor);
        } else {
            isWebViewLoaded = true;
            checkIfEveryThingIsLoaded();
            content.setVisibility(View.GONE);
        }

        if (campaign.getContentBackgroundColor() != null && !campaign.getContentBackgroundColor().isEmpty()) {
            //titleLayout.setBackgroundColor(ColorUtils.setAlphaComponent(Color.parseColor(campaign.getContentBackgroundColor()), 0xAA));
            textPart.setBackgroundColor(ColorUtils.setAlphaComponent(Color.parseColor(campaign.getContentBackgroundColor()), 0xAA));
        }

        try {
            if(mediaPlayer == null) {
                //mediaPlayer = MediaPlayer.create(getActivity(), Uri.parse(ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getMedia()));
                mediaPlayer = new MediaPlayer();
                mediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
                mediaPlayer.setDataSource(ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getMedia());
                //mediaPlayer.setDataSource("http://staging.sweepin.fr/uploads/media/animations/encoded/test/output.m3u8");
                //mediaPlayer.setDataSource("http://devimages.apple.com/iphone/samples/bipbop/bipbopall.m3u8");
                mediaPlayer.prepareAsync();

                mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
                    @Override
                    public void onPrepared(MediaPlayer mp) {
                        isMediaPrepared = true;
                        duration.setText(formatTime(mp.getDuration()));
                        timeline.setMax(mp.getDuration());
                        mediaPlayer.start();
                        mediaPlayer.pause();
                        checkIfEveryThingIsLoaded();
                    }
                });

                mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
                    @Override
                    public void onCompletion(MediaPlayer mp) {
                        if (isMediaPrepared) {
                            progressTime.setText(formatTime(mp.getDuration()));
                            //playOrPause.setText(getResources().getString(R.string.icn_play));
                            playOrPause.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_play_media));
                        }
                    }
                });

                mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener() {
                    @Override
                    public boolean onError(MediaPlayer mp, int what, int extra) {
                        isMediaPrepared = false;
                        return false;
                    }
                });

                timeline.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
                    @Override
                    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                        if (fromUser) {
                            mediaPlayer.seekTo(progress);
                            seekBar.setProgress(progress);
                        }
                    }

                    @Override
                    public void onStartTrackingTouch(SeekBar seekBar) {

                    }

                    @Override
                    public void onStopTrackingTouch(SeekBar seekBar) {

                    }
                });

                playOrPause.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (isMediaPrepared) {
                            if (!mediaPlayer.isPlaying()) {
                                play();
                            } else {
                                mediaPlayer.pause();
                                timeElapsed = mediaPlayer.getCurrentPosition();
                                //playOrPause.setText(getResources().getString(R.string.icn_play));
                                playOrPause.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_play_media));
                            }
                        }
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play() {
        if(isMediaPrepared) {
            timeline.setProgress(timeElapsed);
            durationHandler.postDelayed(updateSeekBarTime, 100);
            mediaPlayer.start();
            if(mediaPlayer.isPlaying())
                playOrPause.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_pause_media));
                //playOrPause.setText(getResources().getString(R.string.icn_pause));
        }
    }

    private Runnable updateSeekBarTime = new Runnable() {
        public void run() {
            if(mediaPlayer != null) {
                timeElapsed = mediaPlayer.getCurrentPosition();
                timeline.setProgress(timeElapsed);
                progressTime.setText(formatTime(timeElapsed));
                durationHandler.postDelayed(this, 100);
            }
        }
    };

    private String formatTime(long millis){
        String mn = "";
        String s = "";
        if(TimeUnit.MILLISECONDS.toMinutes(millis) < 10){
            mn = "0" + String.valueOf(TimeUnit.MILLISECONDS.toMinutes(millis));
        } else {
            mn = String.valueOf(TimeUnit.MILLISECONDS.toMinutes(millis));
        }
        if((TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis))) <  10){
            s = "0" + String.valueOf(TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        } else {
            s = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        }
        return mn+":"+s;
    }

    private void checkIfEveryThingIsLoaded(){
        if(isWebViewLoaded && isImageLoaded && isMediaPrepared){
            spinner.setVisibility(View.GONE);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if(!EventBus.getDefault().isRegistered(this))
            EventBus.getDefault().register(this);
    }

    @Override
    public void onPause() {
        super.onPause();
        EventBus.getDefault().unregister(this);
        if(mediaPlayer != null && playOrPause != null) {
            if(isMediaPrepared) {
                mediaPlayer.pause();
                playOrPause.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_play_media));
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        durationHandler.removeCallbacks(updateSeekBarTime);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (mediaPlayer != null) {
            mediaPlayer.release();
            mediaPlayer = null;
        }
    }
}
