package com.proximities.sdk.fragment;

import android.app.AlertDialog;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.util.Base64;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.json.model.loyalty.BaseLoyalty;
import com.proximities.sdk.json.model.loyalty.LoyaltyError;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.request.api.LoyaltyRequest;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.SharedCampaign;
import com.proximities.sdk.bridge.OnUrlRequestListener;
import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.util.ProximitiesPrefs;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 30/12/14.
 */
public class AnimFragment extends Fragment{

    private ImageView banner;
    private ImageView image;
    private LinearLayout textPart;
    private RelativeLayout mainLayout;
    private TextView title;
    private WebView content;
    private ProgressBar spinner;
    private FrameLayout shareBar;
    private ScrollView scrollView;
    private LinearLayout resetLoyaltyLayout;
    private Button btnAcceptResetLoyalty;
    private Button btnRefuseResetLoyalty;
    private static OnUrlRequestListener urlRequestListener;
    private boolean isAnimOpened = false;
    private boolean isBannerLoaded = false;
    private boolean isImageLoaded = false;
    private boolean isWebViewLoaded = false;

    private Campaign campaign;

    public static AnimFragment newInstance(OnUrlRequestListener OnUrlRequestListener) {
        urlRequestListener = OnUrlRequestListener;
        AnimFragment fragment = new AnimFragment();
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View v = inflater.inflate(R.layout.anim_fragment, container, false);
        mainLayout = (RelativeLayout) v.findViewById(R.id.main_layout);
        banner = (ImageView) v.findViewById(R.id.banner);
        image = (ImageView) v.findViewById(R.id.image);
        textPart = (LinearLayout) v.findViewById(R.id.text_part);
        title = (TextView) v.findViewById(R.id.title);
        content = (WebView) v.findViewById(R.id.content);
        shareBar = (FrameLayout) v.findViewById(R.id.share_bar);
        spinner = (ProgressBar) v.findViewById(R.id.spinner);
        scrollView = (ScrollView) v.findViewById(R.id.scrollView);
        resetLoyaltyLayout = (LinearLayout) v.findViewById(R.id.loyalty_reset_layout);
        btnAcceptResetLoyalty = (Button) v.findViewById(R.id.btn_reset_accept);
        btnRefuseResetLoyalty = (Button) v.findViewById(R.id.btn_reset_refuse);
        return v;
    }


    /**
     * Retrieve informations sent by {@link com.proximities.sdk.ProximitiesAnimationActivity}
     *
     * @param data  {@link Campaign} object
     */
    @Subscribe(sticky = true)
    public void onEventMainThread(Campaign data) {
        if(!isAnimOpened) {
            campaign = data;
            isAnimOpened = true;
            if (campaign.getTemplateType() != null) {
                if (campaign.getTemplateType().equals(ProximitiesConstants.SIMPLE_NOTIF) || campaign.getTemplateType().equals(ProximitiesConstants.RICH_NOTIF)) {
                    resetLoyaltyLayout.setVisibility(View.GONE);
                    displayImages();
                    displayContent();
                }
                if (campaign.getTemplateType().equals(ProximitiesConstants.WEBVIEW_NOTIF)) {
                    resetLoyaltyLayout.setVisibility(View.GONE);
                    displayWebviewNotif();
                }
                if(campaign.getTemplateType().equals(ProximitiesConstants.LOYALTY_NOTIF)) {
                    displayImages();
                    displayContent();
                    displayLoyaltyReset();
                }
            }
        }
    }

    private void displayLoyaltyReset(){
        if(campaign.getNbStamps() != 0 && campaign.getUserStamps() == campaign.getNbStamps()) {
            resetLoyaltyLayout.setVisibility(View.VISIBLE);
            btnAcceptResetLoyalty.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    LayoutInflater factory = LayoutInflater.from(getActivity());
                    final View dialogView = factory.inflate(R.layout.two_choices_dialog, null);
                    final AlertDialog dialog = new AlertDialog.Builder(getActivity()).create();
                    dialog.setView(dialogView);

                    final TextView title = (TextView) dialogView.findViewById(R.id.title_dialog);
                    title.setText(getString(R.string.loyalty_confirm_refresh_title));

                    final TextView content = (TextView) dialogView.findViewById(R.id.content_dialog);
                    content.setText(getString(R.string.loyalty_confirm_refresh_content));

                    final Button buttonYes = (Button) dialogView.findViewById(R.id.choice_positive);
                    buttonYes.setText(getString((R.string.agree)));
                    buttonYes.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            spinner.setVisibility(View.VISIBLE);
                            LoyaltyRequest request = LoyaltyRequest.getInstance(ApplicationUtil.getMyInstance().getMyApp());
                            request.executePost(campaign.getId());
                            dialog.dismiss();
                        }
                    });

                    final Button buttonCancel = (Button) dialogView.findViewById(R.id.choice_negative);
                    buttonCancel.setText(getString((R.string.disagree)));
                    buttonCancel.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            dialog.dismiss();
                        }
                    });

                    dialog.show();

                }
            });

            btnRefuseResetLoyalty.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    resetLoyaltyLayout.setVisibility(View.GONE);
                }
            });
        }
    }

    @Subscribe
    public void onEventMainThread(BaseLoyalty data) {
        campaign = data.getData().getCampaigns().get(0);
        displayContent();
        resetLoyaltyLayout.setVisibility(View.GONE);
        spinner.setVisibility(View.GONE);
    }

    @Subscribe
    public void onEventMainThread(LoyaltyError error) {
        spinner.setVisibility(View.GONE);
        Toast.makeText(getActivity(), getActivity().getString(R.string.loyalty_confirm_refresh_error), Toast.LENGTH_LONG).show();
    }

    private void displayImages() {
        if (campaign.getBanner() != null && !campaign.getBanner().isEmpty()) {
            banner.setVisibility(View.VISIBLE);
            String url = BuildConfig.HOST + campaign.getBanner();
            Glide.with(getActivity()).load(url)
                    .asBitmap()
                    .into(new SimpleTarget<Bitmap>() {
                        @Override
                        public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                            banner.setImageBitmap(resource);
                            isBannerLoaded = true;
                            checkIfEveryThingIsLoaded();
                        }

                        @Override
                        public void onLoadFailed(Exception e, Drawable errorDrawable) {
                            isBannerLoaded = true;
                            checkIfEveryThingIsLoaded();
                            if(campaign.getBannerOffline()!= null && !campaign.getBannerOffline().isEmpty()) {
                                byte[] decodedString = Base64.decode(campaign.getBannerOffline(), Base64.DEFAULT);
                                banner.setImageBitmap(BitmapFactory.decodeByteArray(decodedString, 0, decodedString.length));
                            }
                            super.onLoadFailed(e, errorDrawable);
                        }
                    });
            banner.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
        } else {
            isBannerLoaded = true;
            banner.setVisibility(View.GONE);
        }
        if (campaign.getImage() != null && !campaign.getImage().isEmpty()) {
            image.setVisibility(View.VISIBLE);
            String url = BuildConfig.HOST + campaign.getImage();
            Glide.with(getActivity()).load(url)
                    .asBitmap()
                    .into(new SimpleTarget<Bitmap>() {
                        @Override
                        public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
                            isImageLoaded = true;
                            checkIfEveryThingIsLoaded();
                            image.setImageBitmap(resource);
                        }

                        @Override
                        public void onLoadFailed(Exception e, Drawable errorDrawable) {
                            isImageLoaded = true;
                            checkIfEveryThingIsLoaded();
                            if(campaign.getImageOffline()!= null && !campaign.getImageOffline().isEmpty()) {
                                byte[] decodedString = Base64.decode(campaign.getImageOffline(), Base64.DEFAULT);
                                image.setImageBitmap(BitmapFactory.decodeByteArray(decodedString, 0, decodedString.length));
                            }
                            super.onLoadFailed(e, errorDrawable);
                        }
                    });
            image.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));

        } else {
            isImageLoaded = true;
            image.setVisibility(View.GONE);
        }
    }

    private void displayContent() {
        int textColor = ContextCompat.getColor(getActivity(), android.R.color.black);  // TODO define a default content font color
        if (campaign.getContentFontColor() != null && !campaign.getContentFontColor().isEmpty()) {
            textColor = Color.parseColor(campaign.getContentFontColor());
        }
        if (campaign.getContentTitle() != null && !campaign.getContentTitle().isEmpty()) {
            //title.setVisibility(View.VISIBLE);
            title.setText(campaign.getContentTitle());
            title.setTextColor(textColor);
        } else {
            title.setVisibility(View.GONE);
        }
        if (campaign.getContentText() != null && !campaign.getContentText().isEmpty()) {
            content.setVisibility(View.VISIBLE);
            content.setBackgroundColor(Color.TRANSPARENT);
            String myHtml = "<html><head>"
                    + "<style type=\"text/css\">body{color: " + campaign.getContentFontColor() + ";}"
                    + "</style>"
                    + "</head>"
                    + "<body>"
                    + campaign.getContentText()
                    + "</body></html>";
            content.loadDataWithBaseURL(null, myHtml, "text/html", "UTF-8", null);
            content.setWebViewClient(new WebViewClient() {
                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if(Patterns.WEB_URL.matcher(url).matches()) {
                        boolean isUrlHandled = false;
                        if(ProximitiesConfig.getInstance() != null){
                            if(ProximitiesConfig.getOnCampaignURLClickListener() != null) isUrlHandled = ProximitiesConfig.getOnCampaignURLClickListener().onCampaignURLCLick(url);
                            else if(ProximitiesConfig.getOnItemWebViewClickListener() != null) isUrlHandled = ProximitiesConfig.getOnItemWebViewClickListener().onItemWebViewClick(url);
                        }
                        if(!isUrlHandled)
                            urlRequestListener.displayUrlView(url);
                    } else {
                        Intent callIntent = new Intent(Intent.ACTION_DIAL);
                        callIntent.setData(Uri.parse("tel:" + url));
                        startActivity(callIntent);
                    }
                    return true;
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    isWebViewLoaded = true;
                    checkIfEveryThingIsLoaded();
                    super.onPageFinished(view, url);
                }
            });
            // content.setText(Html.fromHtml(campaign.getContentText()));
            // content.setTextColor(textColor);
        } else {
            isWebViewLoaded = true;
            content.setVisibility(View.GONE);
        }
        if (campaign.getContentBackgroundColor() != null && !campaign.getContentBackgroundColor().isEmpty()) {
            textPart.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
            mainLayout.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
        }
        if (campaign.getTemplateType().equals(ProximitiesConstants.RICH_NOTIF)) {
            if(ProximitiesPrefs.readShareFragment(getActivity()) != null && !ProximitiesPrefs.readShareFragment(getActivity()).isEmpty()) {
                shareBar.setVisibility(View.VISIBLE);
                if (campaign.getContentBackgroundColor() != null && !campaign.getContentBackgroundColor().isEmpty()) {
                    shareBar.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
                }
                try {
                    ShareFragment shareFragment = (ShareFragment) Class.forName(ProximitiesPrefs.readShareFragment(getActivity())).newInstance();
                    shareFragment.setSharedCampaign(new SharedCampaign(campaign.getType(), campaign.getTitle(), ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getImage(), campaign.getContentFontColor()));
                    getFragmentManager().beginTransaction()
                            .replace(R.id.share_bar, shareFragment, "share")
                            .commit();
                } catch (java.lang.InstantiationException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        } else {
            shareBar.setVisibility(View.GONE);
        }
    }

    private void checkIfEveryThingIsLoaded(){
        if(isWebViewLoaded && isImageLoaded && isBannerLoaded){
            spinner.setVisibility(View.GONE);
        }
    }

    private void displayWebviewNotif() {
        banner.setVisibility(View.GONE);
        title.setVisibility(View.GONE);
        textPart.setPadding(0, 0, 0, 0);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
        params.setMargins(0,0,0,0);
        content.setLayoutParams(params);

        WebSettings settings = content.getSettings();
        settings.setJavaScriptEnabled(true);
        content.setWebViewClient(new WebViewClient(){
            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                spinner.setVisibility(View.GONE);
            }
        });
        content.loadUrl(campaign.getWebviewUrl());
    }

    /*private void displayAudioVisualNotif(Map<String, String> params) {
        banner.setVisibility(View.GONE);
        title.setVisibility(View.GONE);
        textPart.setPadding(0, 0, 0, 0);  // remove padding
        WebSettings settings = content.getSettings();
        settings.setJavaScriptEnabled(true);
        content.setWebChromeClient(new WebChromeClient());
        content.loadUrl(ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getWebviewUrl(), params);
    }*/

    /*private void displayVideoNotif(Map<String, String> params) {
        banner.setVisibility(View.GONE);
        title.setVisibility(View.GONE);
        textPart.setPadding(0, 0, 0, 0);  // remove padding
        WebSettings settings = content.getSettings();
        settings.setJavaScriptEnabled(true);
        content.setWebChromeClient(new WebChromeClient());
        content.loadUrl(ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getWebviewUrl(), params);
    }*/

    @Override
    public void onStart() {
        super.onStart();
        if(!EventBus.getDefault().isRegistered(this))
            EventBus.getDefault().register(this);
    }

    @Override
    public void onResume() {
        super.onResume();
        if(campaign != null && (campaign.getTemplateType().equals(ProximitiesConstants.AUDIO_NOTIF) || campaign.getTemplateType().equals(ProximitiesConstants.VIDEO_NOTIF)) && content != null)
            content.onResume();
    }

    @Override
    public void onPause() {
        EventBus.getDefault().unregister(this);
        super.onPause();
        if(campaign != null && (campaign.getTemplateType().equals(ProximitiesConstants.AUDIO_NOTIF) || campaign.getTemplateType().equals(ProximitiesConstants.VIDEO_NOTIF)) && content != null)
            content.onPause();
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        if(campaign != null && (campaign.getTemplateType().equals(ProximitiesConstants.AUDIO_NOTIF) || campaign.getTemplateType().equals(ProximitiesConstants.VIDEO_NOTIF)) && content != null)
            content.destroy();
    }
}
