package com.proximities.sdk.util;

import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;

/**
 * You can access to simple data by :
 * ProximitiesConstants.DEFAULT_LAT
 *
 * For sensitive data like api url, you must use the following access :
 * ProximitiesConstants.access().getWS_OFFERS()
 *
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 22/11/14.
 */
public final class ProximitiesConstants {

    public static String STATIC_CONTENT_HOST = BuildConfig.HOST;  // Used to access to static content

    private String WS_PARTNER;
    private String WS_CLOSEST_POI;
    private String WS_FEED;
    private String WS_PARTNER_AUTOCOMPLETE;
    private String WS_EXCLUDED_PARTNERS;
    private String WS_CITIES;
    private String WS_SEGMENTATION_USER;
    private String WS_TRANSMITTERS;
    private String WS_LOGS;
    private String WS_ANIM;
    private String WS_LOYALTY;
    private String WS_CATEGORIES;
    private String WS_EXCLUDED_CATEGORIES;
    private String WS_EXCLUDED_BRANDS;
    private String WS_ENTRY_LOGS;
    private String WS_EXIT_LOGS;

    // Dijon as default city
    public static final float DEFAULT_LAT = 47.322047f;
    public static final float DEFAULT_LNG = 5.04148f;

    public static final String ANIM_RECEIVED = "anim_received";
    public static final String PUSH_ENGAGED = "push_engaged";
    public static final String SAVED = "saved";
    public static final String DISMISS = "dismiss";
    public static final String DELETE = "delete";

    public static final String LIKE_API_ERROR = "user_already_likes";

    public static final String EXTRA_ANIMS = "anims";
    public static final String ANIM_BY_PUSH = "anim_by_push";
    public static final String IS_BACKGROUND = "is_background";
    public static final String EXTRA_CHECK_BLE_IS_ENABLED = "ble";
    public static final String EXTRA_DELETE_OPTION = "del";
    public static final String EXTRA_DELETE_ANIM = "del_anim";
    public static final String EXTRA_ACTION_BUTTON_VALUE = "action_button_value";
    public static final String EXTRA_URL = "extra_url";

    public static final int RESULT_DELETED_ANIM = 1;

    public static final String HUNGRY       = "hungry";
    public static final String SHOPPING     = "shopping";
    public static final String TOURIST      = "tourist";
    public static final String THIRSTY      = "thirsty";
    public static final String DO_NOT_DISTURB      = "do_not_disturb";

    public static final String RICH_NOTIF     = "rich-notification";
    public static final String WEBVIEW_NOTIF    = "webview-notification";
    public static final String SIMPLE_NOTIF     = "simple-notification";
    public static final String AUDIO_NOTIF = "audio-notification";
    public static final String VIDEO_NOTIF     = "video-notification";
    public static final String LOYALTY_NOTIF     = "loyalty-notification";

    public static final String TYPE_PROMOTION = "promotion";
    public static final String TYPE_INFORMATION = "information";
    public static final String TYPE_EVENTS = "events";
    public static final String TYPE_LAST_NOTIFS = "lastNotifs";

    public static final String EXTRA_IDENTIFIER = "identifier";

    public static int[] getGeofencesRadius() {
        return geofencesRadius;
    }

    private static final int[] geofencesRadius = { 100, 200, 300, 400, 500};

    private static final ProximitiesConstants ourInstance = new ProximitiesConstants();
    public static ProximitiesConstants access() {
        return ourInstance;
    }

    private ProximitiesConstants() {
        WS_PARTNER                  = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_partner);
        WS_CLOSEST_POI              = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_closest_poi);
        WS_FEED                     = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_feed);
        WS_PARTNER_AUTOCOMPLETE     = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_partner_autocomplete);
        WS_EXCLUDED_PARTNERS        = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_excluded_partner);
        WS_CITIES                   = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_cities);
        WS_SEGMENTATION_USER        = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_user_seg);
        WS_TRANSMITTERS             = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_transmitter);
        WS_LOGS                     = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_logs);
        WS_ANIM                     = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_favorites);
        WS_LOYALTY                  = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_loyalty);
        WS_CATEGORIES               = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_categories);
        WS_EXCLUDED_CATEGORIES      = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_excluded_categories);
        WS_EXCLUDED_BRANDS          = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_excluded_brands);
        WS_ENTRY_LOGS               = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_entry_logs);
        WS_EXIT_LOGS                = BuildConfig.HOST + ApplicationUtil.getMyInstance().getMyApp().getString(R.string.ws_exit_logs);
    }

    public String getWS_PARTNER() {
        return WS_PARTNER;
    }
    public String getWS_CLOSEST_POI() {
        return WS_CLOSEST_POI;
    }
    public String getWS_FEED() {
        return WS_FEED;
    }
    public String getWS_PARTNER_AUTOCOMPLETE() {
        return WS_PARTNER_AUTOCOMPLETE;
    }
    public String getWS_EXCLUDED_PARTNERS() {
        return WS_EXCLUDED_PARTNERS;
    }
    public String getWS_CITIES() {
        return WS_CITIES;
    }
    public String getWS_SEGMENTATION_USER() {
        return WS_SEGMENTATION_USER;
    }
    public String getWS_TRANSMITTERS() {
        return WS_TRANSMITTERS;
    }
    public String getWS_LOGS() {
        return WS_LOGS;
    }
    public String getWS_ANIM() {
        return WS_ANIM;
    }
    public String getWS_LOYALTY() {
        return WS_LOYALTY;
    }
    public String getWS_CATEGORIES() {
        return WS_CATEGORIES;
    }
    public String getWS_EXCLUDED_CATEGORIES() {
        return WS_EXCLUDED_CATEGORIES;
    }
    public String getWS_EXCLUDED_BRANDS() {
        return WS_EXCLUDED_BRANDS;
    }
    public String getWS_EXIT_LOGS() {
        return WS_EXIT_LOGS;
    }
    public String getWS_ENTRY_LOGS() {
        return WS_ENTRY_LOGS;
    }

}
