package com.proximities.sdk.request.api;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.json.model.transmitter.BaseQrCode;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;

import org.greenrobot.eventbus.EventBus;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 07/09/16.
 */
public final class QRCodeRequest implements Response.Listener<BaseQrCode>, Response.ErrorListener {

    private static final String TAG = makeLogTag(QRCodeRequest.class);

    public QRCodeRequest() {
    }

    public void executeGet(String uuid, String major, String minor) {
        String url = ProximitiesConstants.access().getWS_TRANSMITTERS() + "/" + uuid + "/" + major + "/" + minor;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ApplicationUtil.getMyInstance().getMyApp(), "GET&" + url);
        GsonRequest<BaseQrCode> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseQrCode.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseQrCode baseTransmitter) {
        if (baseTransmitter != null) {
            ProximitiesConstants.STATIC_CONTENT_HOST = baseTransmitter.getServerUrl();
            EventBus.getDefault().post(baseTransmitter);
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(ProximitiesConfig.getOnResponseFromQrScanListener() != null) ProximitiesConfig.getOnResponseFromQrScanListener().onErrorOnQrCodeResponse();
    }

}