package com.proximities.sdk.request.api;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.json.model.transmitter.BaseNfc;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;

import org.greenrobot.eventbus.EventBus;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 05/09/16.
 */
public final class NfcRequest implements Response.Listener<BaseNfc>, Response.ErrorListener {

    private static final String TAG = makeLogTag(NfcRequest.class);

    public NfcRequest() {
    }

    public void executeGet(String uuid, String major, String minor) {
        String url = ProximitiesConstants.access().getWS_TRANSMITTERS() + "/" + uuid + "/" + major + "/" + minor;
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ApplicationUtil.getMyInstance().getMyApp(), "GET&" + url);
        GsonRequest<BaseNfc> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseNfc.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseNfc baseNfc) {
        EventBus.getDefault().post(baseNfc);
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {

    }

}
