package com.proximities.sdk.request.api;

import android.app.Activity;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.json.model.cities.BaseCity;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;

import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by william on 08/09/15.
 */
public class CitiesRequest implements Response.Listener<BaseCity>, Response.ErrorListener {

    private static final String TAG = makeLogTag(CitiesRequest.class);

    private static CitiesRequest ourInstance;
    private Activity ctx;

    public static CitiesRequest getInstance(Activity ctx) {
        if (ourInstance == null) {
            ourInstance = new CitiesRequest(ctx);
        }
        return ourInstance;
    }

    private CitiesRequest() {
    }

    private CitiesRequest(Activity ctx) {
        this.ctx = ctx;
    }

    public void executeGet() {
        String url = ProximitiesConstants.access().getWS_CITIES();
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "GET&" + url);
        GsonRequest<BaseCity> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseCity.class,
                params,
                this,
                this);
        request.setShouldCache(true);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {

    }

    @Override
    public void onResponse(BaseCity baseCity) {
        ProximitiesConstants.STATIC_CONTENT_HOST = baseCity.getServerUrl();
        LOGD(TAG, "static url : " + baseCity.getServerUrl());
        EventBus.getDefault().post(baseCity);
    }


}
