package com.proximities.sdk.request.api;

import android.app.Activity;

import com.proximities.sdk.json.model.category.BaseCategories;
import com.proximities.sdk.json.model.error.ErrorData;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.ProximitiesConstants;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.google.gson.Gson;

import java.util.Map;

import org.greenrobot.eventbus.EventBus;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by victo_000 on 25/01/2015.
 */
public class CategoriesRequest implements Response.Listener<BaseCategories>, Response.ErrorListener {
    private static final String TAG = makeLogTag(CategoriesRequest.class);

    private static CategoriesRequest ourInstance;
    private Activity ctx;

    public static CategoriesRequest getInstance(Activity ctx) {
        if (ourInstance == null) {
            ourInstance = new CategoriesRequest(ctx);
        }
        return ourInstance;
    }

    private CategoriesRequest() {}
    private CategoriesRequest(Activity ctx) {
        this.ctx = ctx;
    }

    public void executeGet() {
        String url = ProximitiesConstants.access().getWS_CATEGORIES();
        LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "GET&" + url);
        GsonRequest<BaseCategories> request = new GsonRequest(
                Request.Method.GET,
                url,
                BaseCategories.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseCategories result) {
        EventBus.getDefault().post(result);
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        NetworkResponse response = volleyError.networkResponse;
        if (response != null && response.data != null) {
            switch (response.statusCode) {
                case 400 :
                    ErrorData errorData = new Gson().fromJson(new String(response.data), ErrorData.class);
                    errorData.setStatusCode(response.statusCode);
                    EventBus.getDefault().post(errorData);
                    break;
            }
        }
    }
}
