package com.proximities.sdk.request.api;

import android.app.Application;

import com.android.volley.NetworkResponse;
import com.proximities.sdk.database.DatabaseHandler;
import com.proximities.sdk.json.WsHeader;
import com.proximities.sdk.json.model.animation.AnimationData;
import com.proximities.sdk.json.model.animation.DeletedAnimation;
import com.proximities.sdk.json.model.animation.ErrorAnimation;
import com.proximities.sdk.json.model.animation.SavedAnimation;
import com.proximities.sdk.json.model.partner.BasePartner;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.ApplicationUtil;
import com.proximities.sdk.util.LogUtils;
import com.proximities.sdk.util.ProximitiesConstants;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import java.util.Map;

import org.greenrobot.eventbus.EventBus;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 04/01/15.
 */
public final class AnimationRequest implements Response.Listener<WsHeader>, Response.ErrorListener {

    private static final String TAG = LogUtils.makeLogTag(AnimationRequest.class);

    private static int methodHttp;
    private static Application app;
    private int animId;

    private static AnimationRequest ourInstance;

    public static AnimationRequest getInstance(Application pApp) {
        app = pApp;
        if (ourInstance == null) {
            ourInstance = new AnimationRequest();
        }
        return ourInstance;
    }

    private AnimationRequest() { }

    public void executePost(int animationId) {
        animId = animationId;
        methodHttp = Request.Method.POST;
        String url = ProximitiesConstants.access().getWS_ANIM() + "/" + animationId + "/archive";
        LogUtils.LOGD(TAG, "POST : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(app, "POST&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.POST,
                url,
                WsHeader.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    public void executeGet() {
        methodHttp = Request.Method.GET;
        String url = ProximitiesConstants.access().getWS_ANIM();
        LogUtils.LOGD(TAG, "GET : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(app, "GET&" + url);
        GsonRequest<AnimationData> request = new GsonRequest(
                Request.Method.GET,
                url,
                AnimationData.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    public void executeDel(int animationId) {
        methodHttp = Request.Method.DELETE;
        String url = ProximitiesConstants.access().getWS_ANIM() + "/" + animationId;
        LogUtils.LOGD(TAG, "DELETE : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(app, "DELETE&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.DELETE,
                url,
                WsHeader.class,
                params,
                this,
                this);
        ApplicationUtil.getMyInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(WsHeader wsHeader) {
        if (methodHttp == Request.Method.POST) {
            EventBus.getDefault().post(new SavedAnimation());
        } else if (methodHttp == Request.Method.GET && wsHeader != null) {
            ProximitiesConstants.STATIC_CONTENT_HOST = wsHeader.getServerUrl();
            AnimationData data = (AnimationData) wsHeader;
            EventBus.getDefault().post(data);
        } else if (methodHttp == Request.Method.DELETE) {
            EventBus.getDefault().post(new DeletedAnimation());
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if (methodHttp == Request.Method.POST) {
            DatabaseHandler db = new DatabaseHandler(app.getApplicationContext());
            db.insertLogsIntoDatabase(animId, ProximitiesConstants.SAVED);
            db.close();
            EventBus.getDefault().post(new SavedAnimation());
            }
        NetworkResponse response = volleyError.networkResponse;
        if (response != null && response.data != null) {
            switch (response.statusCode) {
                case 400 :
                    if(methodHttp == Request.Method.GET)
                        EventBus.getDefault().post(new ErrorAnimation());
                    break;
            }
        }
    }
}
